/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.reflect.Method;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.log.Trace;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherSpeedTest
implements MembershipListener {
    Channel channel;
    RpcDispatcher disp;
    String props = null;
    boolean server = false;
    int num = 1000;
    int mode = 1;
    static final int OLD = 1;
    static final int METHOD = 2;
    static final int TYPES = 3;
    static final int SIGNATURE = 4;
    static final long TIMEOUT = 10000L;
    static final Class LONG_CLASS = Long.TYPE;
    static final String LONG = Long.TYPE.getName();

    public RpcDispatcherSpeedTest(String props, boolean server, int num, int mode) {
        this.props = props;
        this.server = server;
        this.num = num;
        this.mode = mode;
    }

    public long measure(long start_time) throws Exception {
        return System.currentTimeMillis() - start_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this);
        this.channel.connect("RpcDispatcherSpeedTestGroup");
        try {
            try {
                if (this.server) {
                    System.out.println("-- Started as server. Press ctrl-c to kill");
                    while (true) {
                        Util.sleep(10000L);
                    }
                }
                this.invokeRpcs(this.num, this.mode);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                Object var3_2 = null;
                System.out.println("Closing channel");
                this.channel.close();
                System.out.println("Closing channel: -- done");
                System.out.println("Stopping dispatcher");
                this.disp.stop();
                System.out.println("Stopping dispatcher: -- done");
                return;
            }
            Object var3_1 = null;
            System.out.println("Closing channel");
            this.channel.close();
            System.out.println("Closing channel: -- done");
            System.out.println("Stopping dispatcher");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            System.out.println("Closing channel");
            this.channel.close();
            System.out.println("Closing channel: -- done");
            System.out.println("Stopping dispatcher");
            this.disp.stop();
            System.out.println("Stopping dispatcher: -- done");
            throw throwable;
        }
        this.disp.stop();
        System.out.println("Stopping dispatcher: -- done");
    }

    void invokeRpcs(int num, int mode) throws Exception {
        long total_time = 0L;
        int show = num / 10;
        if (show <= 0) {
            show = 1;
        }
        switch (mode) {
            case 1: {
                System.out.println("-- invoking " + num + " methods using mode=OLD");
                for (int i = 1; i <= num; ++i) {
                    Long start_time = new Long(System.currentTimeMillis());
                    RspList rsp_list = this.disp.callRemoteMethods(null, "measure", start_time, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                this.printStats(total_time, num);
                break;
            }
            case 2: {
                System.out.println("-- invoking " + num + " methods using mode=METHOD");
                Method method = this.getClass().getMethod("measure", Long.TYPE);
                for (int i = 1; i <= num; ++i) {
                    Long start_time = new Long(System.currentTimeMillis());
                    MethodCall method_call = new MethodCall(method, new Object[]{start_time});
                    RspList rsp_list = this.disp.callRemoteMethods(null, method_call, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                this.printStats(total_time, num);
                break;
            }
            case 3: {
                System.out.println("-- invoking " + num + " methods using mode=TYPES");
                for (int i = 1; i <= num; ++i) {
                    Long start_time = new Long(System.currentTimeMillis());
                    RspList rsp_list = this.disp.callRemoteMethods((Vector)null, "measure", new Object[]{start_time}, new Class[]{LONG_CLASS}, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                this.printStats(total_time, num);
                break;
            }
            case 4: {
                System.out.println("-- invoking " + num + " methods using mode=SIGNATURE");
                for (int i = 1; i <= num; ++i) {
                    Long start_time = new Long(System.currentTimeMillis());
                    RspList rsp_list = this.disp.callRemoteMethods((Vector)null, "measure", new Object[]{start_time}, new String[]{LONG}, 2, 10000L);
                    total_time = (long)((double)total_time + this.getAverage(rsp_list));
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                this.printStats(total_time, num);
                break;
            }
        }
    }

    double getAverage(RspList rsps) {
        double retval = 0.0;
        int num = 0;
        if (rsps == null || rsps.size() == 0) {
            System.err.println("response list is empty");
            return 0.0;
        }
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            if (rsp.getValue() != null && rsp.getValue() instanceof Long) {
                retval += (double)((Long)rsp.getValue()).longValue();
                ++num;
                continue;
            }
            System.err.println("response " + rsp.getValue() + " invalid");
        }
        return retval / (double)num;
    }

    void printStats(long total_time, int num) {
        System.out.println("total_time for " + num + " remote calls was " + total_time + ", avg=" + (double)total_time / (double)num + "ms/invocation");
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public static void main(String[] args) {
        String props = null;
        boolean server = false;
        int num = 1000;
        int mode = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-server")) {
                server = true;
                continue;
            }
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-mode")) {
                String m;
                if ((m = args[++i].toLowerCase().trim()).equals("old")) {
                    mode = 1;
                    continue;
                }
                if (m.equals("method")) {
                    mode = 2;
                    continue;
                }
                if (m.equals("types")) {
                    mode = 3;
                    continue;
                }
                if (m.equals("signature")) {
                    mode = 4;
                    continue;
                }
                System.err.println("mode " + m + " is invalid");
                RpcDispatcherSpeedTest.help();
                return;
            }
            RpcDispatcherSpeedTest.help();
            return;
        }
        Trace.init();
        try {
            RpcDispatcherSpeedTest test = new RpcDispatcherSpeedTest(props, server, num, mode);
            test.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-server] [-num <number of calls>] [-mode <mode>]");
        System.out.println("mode can be either 'old', 'method', 'types' or 'signature'");
    }
}

