/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import org.jgroups.Event;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;

class UpHandler
extends Thread {
    private Queue mq = null;
    private Protocol handler = null;
    private ProtocolObserver observer = null;

    public UpHandler(Queue mq, Protocol handler, ProtocolObserver observer) {
        this.mq = mq;
        this.handler = handler;
        this.observer = observer;
        if (handler != null) {
            this.setName("UpHandler (" + handler.getName() + ")");
        } else {
            this.setName("UpHandler");
        }
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
    }

    public void run() {
        while (!this.mq.closed()) {
            try {
                Event evt = (Event)this.mq.remove();
                if (evt == null) {
                    Trace.warn("Protocol.UpHandler.run()", "removed null event");
                    continue;
                }
                if (this.observer != null && !this.observer.up(evt, this.mq.size())) {
                    return;
                }
                this.handler.up(evt);
                evt = null;
            }
            catch (QueueClosedException queue_closed) {
                break;
            }
            catch (Throwable e) {
                Trace.warn("Protocol.UpHandler.run()", this.getName() + " exception: " + e);
                e.printStackTrace();
            }
        }
    }
}

