/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.MethodLookupClos;
import org.jgroups.log.Trace;
import org.jgroups.stack.MessageProtocol;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcProtocol
extends MessageProtocol {
    MethodLookup method_lookup = new MethodLookupClos();

    public String getName() {
        return "RpcProtocol";
    }

    public RspList callRemoteMethods(Vector dests, String method_name, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, Object arg3, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, Object arg3, Object arg4, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3, arg4);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3, arg4, arg5);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            Trace.error("RpcProtocol.callRemoteMethods()", "exception=" + e);
            return null;
        }
        msg = new Message(null, null, buf);
        return this.castMessage(dests, msg, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, Object arg2, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, Object arg2, Object arg3, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, Object arg2, Object arg3, Object arg4, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3, arg4);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3, arg4, arg5);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws TimeoutException, SuspectedException {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            Trace.error("RpcProtocol.callRemoteMethod()", "exception=" + e);
            return null;
        }
        msg = new Message(dest, null, buf);
        return this.sendMessage(msg, mode, timeout);
    }

    public Object handle(Message req) {
        Object body = null;
        if (req == null || req.getBuffer() == null) {
            Trace.error("RpcProtocol.handle()", "message or message buffer is null");
            return null;
        }
        try {
            body = Util.objectFromByteBuffer(req.getBuffer());
        }
        catch (Exception e) {
            Trace.error("RpcProtocol.handle()", "exception=" + e);
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            Trace.error("RpcProtocol.handle()", "message does not contain a MethodCall object");
            return null;
        }
        MethodCall method_call = (MethodCall)body;
        try {
            return method_call.invoke(this, this.method_lookup);
        }
        catch (Throwable x) {
            Trace.error("RpcProtocol.handle()", Trace.getStackTrace(x));
            return x;
        }
    }

    public boolean handleUpEvent(Event evt) {
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        return true;
    }
}

