/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Properties;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.log.Trace;
import org.jgroups.stack.DownHandler;
import org.jgroups.stack.ProtocolObserver;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.UpHandler;
import org.jgroups.util.Queue;

public abstract class Protocol {
    protected Properties props = null;
    protected Protocol up_prot = null;
    protected Protocol down_prot = null;
    protected ProtocolStack stack = null;
    protected Queue up_queue = new Queue();
    protected Queue down_queue = new Queue();
    protected UpHandler up_handler = null;
    protected int up_thread_prio = -1;
    protected DownHandler down_handler = null;
    protected int down_thread_prio = -1;
    protected ProtocolObserver observer = null;
    private final long THREAD_JOIN_TIMEOUT = 1000L;
    protected boolean down_thread = true;
    protected boolean up_thread = true;

    public boolean setProperties(Properties props) {
        this.props = props;
        return true;
    }

    public boolean setPropertiesInternal(Properties props) {
        this.props = (Properties)props.clone();
        String str = props.getProperty("down_thread");
        if (str != null) {
            this.down_thread = new Boolean(str);
            props.remove("down_thread");
        }
        if ((str = props.getProperty("down_thread_prio")) != null) {
            this.down_thread_prio = Integer.parseInt(str);
            props.remove("down_thread_prio");
        }
        if ((str = props.getProperty("up_thread")) != null) {
            this.up_thread = new Boolean(str);
            props.remove("up_thread");
        }
        if ((str = props.getProperty("up_thread_prio")) != null) {
            this.up_thread_prio = Integer.parseInt(str);
            props.remove("up_thread_prio");
        }
        return this.setProperties(props);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
        if (this.up_handler != null) {
            this.up_handler.setObserver(observer);
        }
        if (this.down_handler != null) {
            this.down_handler.setObserver(observer);
        }
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Queue getUpQueue() {
        return this.up_queue;
    }

    public Queue getDownQueue() {
        return this.down_queue;
    }

    public Vector requiredUpServices() {
        return null;
    }

    public Vector requiredDownServices() {
        return null;
    }

    public Vector providedUpServices() {
        return null;
    }

    public Vector providedDownServices() {
        return null;
    }

    public abstract String getName();

    public Protocol getUpProtocol() {
        return this.up_prot;
    }

    public Protocol getDownProtocol() {
        return this.down_prot;
    }

    public void setUpProtocol(Protocol up_prot) {
        this.up_prot = up_prot;
    }

    public void setDownProtocol(Protocol down_prot) {
        this.down_prot = down_prot;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.stack = stack;
    }

    public void startUpHandler() {
        if (this.up_thread && this.up_handler == null) {
            this.up_handler = new UpHandler(this.up_queue, this, this.observer);
            if (this.up_thread_prio >= 0) {
                try {
                    this.up_handler.setPriority(this.up_thread_prio);
                }
                catch (Throwable t) {
                    Trace.error("Protocol.startUpHandler()", "priority " + this.up_thread_prio + " could not be set for thread: " + Trace.getStackTrace(t));
                }
            }
            this.up_handler.start();
        }
    }

    public void startDownHandler() {
        if (this.down_thread && this.down_handler == null) {
            this.down_handler = new DownHandler(this.down_queue, this, this.observer);
            if (this.down_thread_prio >= 0) {
                try {
                    this.down_handler.setPriority(this.down_thread_prio);
                }
                catch (Throwable t) {
                    Trace.error("Protocol.startDownHandler()", "priority " + this.down_thread_prio + " could not be set for thread: " + Trace.getStackTrace(t));
                }
            }
            this.down_handler.start();
        }
    }

    public void stopInternal() {
        this.up_queue.close(false);
        if (this.up_handler != null && this.up_handler.isAlive()) {
            try {
                this.up_handler.join(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.up_handler.isAlive()) {
                this.up_handler.interrupt();
                try {
                    this.up_handler.join(1000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (this.up_handler.isAlive()) {
                    Trace.error("Protocol.stopInternal()", "up_handler thread for " + this.getName() + " was interrupted (in order to be terminated), but is still alive");
                }
            }
        }
        this.up_handler = null;
        this.down_queue.close(false);
        if (this.down_handler != null && this.down_handler.isAlive()) {
            try {
                this.down_handler.join(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.down_handler.isAlive()) {
                this.down_handler.interrupt();
                try {
                    this.down_handler.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.down_handler.isAlive()) {
                    Trace.error("Protocol.stopInternal()", "down_handler thread for " + this.getName() + " was interrupted (in order to be terminated), but is is still alive");
                }
            }
        }
        this.down_handler = null;
    }

    protected void receiveUpEvent(Event evt) {
        if (this.up_handler == null) {
            if (this.observer != null && !this.observer.up(evt, this.up_queue.size())) {
                return;
            }
            this.up(evt);
            return;
        }
        try {
            this.up_queue.add(evt);
        }
        catch (Exception e) {
            Trace.warn("Protocol.receiveUpEvent()", "exception: " + e);
        }
    }

    protected void receiveDownEvent(Event evt) {
        if (this.down_handler == null) {
            if (this.observer != null && !this.observer.down(evt, this.down_queue.size())) {
                return;
            }
            this.down(evt);
            return;
        }
        try {
            this.down_queue.add(evt);
        }
        catch (Exception e) {
            Trace.warn("Protocol.receiveDownEvent()", "exception: " + e);
        }
    }

    public void passUp(Event evt) {
        if (this.observer != null && !this.observer.passUp(evt)) {
            return;
        }
        if (this.up_prot != null) {
            this.up_prot.receiveUpEvent(evt);
        } else {
            Trace.error("Protocol.passUp()", "no upper layer available");
        }
    }

    public void passDown(Event evt) {
        if (this.observer != null && !this.observer.passDown(evt)) {
            return;
        }
        if (this.down_prot != null) {
            this.down_prot.receiveDownEvent(evt);
        } else {
            Trace.error("Protocol.passDown()", "no lower layer available");
        }
    }

    public void up(Event evt) {
        this.passUp(evt);
    }

    public void down(Event evt) {
        this.passDown(evt);
    }
}

