/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.conf.ClassPathEntityResolver;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.log.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigurator
implements ProtocolStackConfigurator {
    private static boolean xml_debug = true;
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_INHERIT = "inherit";
    public static final String ELMT_PROT_OVERRIDE = "protocol-override";
    public static final String ELMT_PROT = "protocol";
    public static final String ELMT_PROT_NAME = "protocol-name";
    public static final String ELMT_CLASS = "class-name";
    public static final String ELMT_DESCRIPTION = "description";
    public static final String ELMT_PROT_PARAMS = "protocol-params";
    private ArrayList mProtocolStack = new ArrayList();
    private String mStackName;

    protected XmlConfigurator(String stackName, ProtocolData[] protocols) {
        this.mStackName = stackName;
        for (int i = 0; i < protocols.length; ++i) {
            this.mProtocolStack.add(protocols[i]);
        }
    }

    protected XmlConfigurator(String stackName) {
        this(stackName, new ProtocolData[0]);
    }

    public static XmlConfigurator getInstance(URL url) throws IOException {
        return XmlConfigurator.getInstance(url.openStream());
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.parse(stream);
    }

    public static XmlConfigurator getInstance(Element el) throws IOException {
        return XmlConfigurator.parse(el);
    }

    public String getProtocolStackString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.mProtocolStack.iterator();
        while (it.hasNext()) {
            ProtocolData d = (ProtocolData)it.next();
            buf.append(d.getProtocolString());
            if (!it.hasNext()) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    public ProtocolData[] getProtocolStack() {
        return this.mProtocolStack.toArray(new ProtocolData[this.mProtocolStack.size()]);
    }

    public String getName() {
        return this.mStackName;
    }

    public void override(ProtocolData data) throws IOException {
        int index = this.mProtocolStack.indexOf(data);
        if (index < 0) {
            throw new IOException("You can not override a protocol that doesn't exist");
        }
        ProtocolData source = (ProtocolData)this.mProtocolStack.get(index);
        source.override(data.getParametersAsArray());
    }

    public void add(ProtocolData data) {
        this.mProtocolStack.add(data);
    }

    protected static XmlConfigurator parse(InputStream stream) throws IOException {
        XmlConfigurator configurator = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ClassPathEntityResolver());
            Document document = builder.parse(stream);
            Element root = (Element)document.getElementsByTagName("protocol-stack").item(0);
            root.normalize();
            String stackname = root.getAttribute(ATTR_NAME);
            String inherit = root.getAttribute(ATTR_INHERIT);
            boolean isinherited = inherit != null && inherit.length() > 0;
            NodeList protocol_list = document.getElementsByTagName(isinherited ? ELMT_PROT_OVERRIDE : ELMT_PROT);
            Vector<ProtocolData> v = new Vector<ProtocolData>();
            for (int i = 0; i < protocol_list.getLength(); ++i) {
                if (protocol_list.item(i).getNodeType() != 1) continue;
                v.addElement(XmlConfigurator.parseProtocolData(protocol_list.item(i)));
            }
            Object[] protocols = new ProtocolData[v.size()];
            v.copyInto(protocols);
            if (isinherited) {
                URL inheritURL = new URL(inherit);
                configurator = XmlConfigurator.getInstance(inheritURL);
                for (int i = 0; i < protocols.length; ++i) {
                    configurator.override((ProtocolData)protocols[i]);
                }
            } else {
                configurator = new XmlConfigurator(stackname, (ProtocolData[])protocols);
            }
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
        return configurator;
    }

    protected static XmlConfigurator parse(Element root) throws IOException {
        XmlConfigurator configurator = null;
        try {
            Document document = root.getOwnerDocument();
            String stackname = root.getAttribute(ATTR_NAME);
            String inherit = root.getAttribute(ATTR_INHERIT);
            boolean isinherited = inherit != null && inherit.length() > 0;
            NodeList protocol_list = document.getElementsByTagName(isinherited ? ELMT_PROT_OVERRIDE : ELMT_PROT);
            Vector<ProtocolData> v = new Vector<ProtocolData>();
            for (int i = 0; i < protocol_list.getLength(); ++i) {
                if (protocol_list.item(i).getNodeType() != 1) continue;
                v.addElement(XmlConfigurator.parseProtocolData(protocol_list.item(i)));
            }
            Object[] protocols = new ProtocolData[v.size()];
            v.copyInto(protocols);
            if (isinherited) {
                URL inheritURL = new URL(inherit);
                configurator = XmlConfigurator.getInstance(inheritURL);
                for (int i = 0; i < protocols.length; ++i) {
                    configurator.override((ProtocolData)protocols[i]);
                }
            } else {
                configurator = new XmlConfigurator(stackname, (ProtocolData[])protocols);
            }
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
        return configurator;
    }

    protected static ProtocolData parseProtocolData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            boolean isOverride = ELMT_PROT_OVERRIDE.equals(protocol.getNodeName());
            int pos = 0;
            NodeList children = protocol.getChildNodes();
            String name = null;
            String clazzname = null;
            String desc = null;
            ProtocolParameter[] plist = null;
            block8: for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                if (isOverride && ++pos == 2) {
                    pos = 4;
                }
                switch (pos) {
                    case 1: {
                        name = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 2: {
                        desc = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 3: {
                        clazzname = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 4: {
                        plist = XmlConfigurator.parseProtocolParameters((Element)children.item(i));
                    }
                }
            }
            if (isOverride) {
                return new ProtocolData(name, plist);
            }
            return new ProtocolData(name, desc, clazzname, plist);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
    }

    protected static ProtocolParameter[] parseProtocolParameters(Element protparams) throws IOException {
        try {
            Vector<ProtocolParameter> v = new Vector<ProtocolParameter>();
            protparams.normalize();
            NodeList parameters = protparams.getChildNodes();
            for (int i = 0; i < parameters.getLength(); ++i) {
                if (parameters.item(i).getNodeType() != 1) continue;
                String pname = parameters.item(i).getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                String pvalue = parameters.item(i).getAttributes().getNamedItem(ATTR_VALUE).getNodeValue();
                ProtocolParameter p = new ProtocolParameter(pname, pvalue);
                v.addElement(p);
            }
            Object[] result = new ProtocolParameter[v.size()];
            v.copyInto(result);
            return result;
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("XmlConfigurator", error);
            throw new IOException(x.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        String input_file = null;
        String output = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-url")) {
                XmlConfigurator.help();
                return;
            }
            input_file = args[++i];
        }
        xml_debug = true;
        if (input_file != null) {
            XmlConfigurator conf = XmlConfigurator.getInstance(new URL(input_file));
            output = conf.getProtocolStackString();
            output = XmlConfigurator.replace(output, "org.jgroups.protocols.", "");
            System.out.println("\n" + output);
        } else {
            System.err.println("no input file given");
        }
    }

    public static String replace(String input, String expr, String replacement) {
        StringBuffer sb = new StringBuffer();
        int new_index = 0;
        int index = 0;
        int len = expr.length();
        int input_len = input.length();
        while (true) {
            if ((new_index = input.indexOf(expr, index)) == -1) break;
            sb.append(input.substring(index, new_index));
            sb.append(replacement);
            index = new_index + len;
        }
        sb.append(input.substring(index, input_len));
        return sb.toString();
    }

    static void help() {
        System.out.println("XmlConfigurator [-help] [-url <URL> ]");
    }
}

