/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.util.HashMap;
import java.util.Iterator;
import org.jgroups.conf.ProtocolParameter;

public class ProtocolData {
    private HashMap mParameters = new HashMap();
    private String mProtocolName;
    private String mDescription;
    private String mClassName;
    private boolean mIsOverRide = false;

    public ProtocolData(String protocolName, String description, String className, ProtocolParameter[] params) {
        this.mProtocolName = protocolName;
        this.mDescription = description;
        this.mClassName = className;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                this.mParameters.put(params[i].getName(), params[i]);
            }
        }
    }

    public ProtocolData(String overRideName, ProtocolParameter[] params) {
        this(overRideName, null, null, params);
        this.mIsOverRide = true;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getProtocolName() {
        return this.mProtocolName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public HashMap getParameters() {
        return this.mParameters;
    }

    public boolean isOverride() {
        return this.mIsOverRide;
    }

    public ProtocolParameter[] getParametersAsArray() {
        ProtocolParameter[] result = new ProtocolParameter[this.mParameters.size()];
        Iterator it = this.mParameters.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            String key = (String)it.next();
            result[i] = (ProtocolParameter)this.mParameters.get(key);
        }
        return result;
    }

    public void override(ProtocolParameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.mParameters.put(params[i].getName(), params[i]);
        }
    }

    public String getProtocolString() {
        StringBuffer buf = new StringBuffer(this.mClassName);
        if (this.mParameters.size() > 0) {
            buf.append("(");
            Iterator i = this.mParameters.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                ProtocolParameter param = (ProtocolParameter)this.mParameters.get(key);
                buf.append(param.getParameterString());
                if (!i.hasNext()) continue;
                buf.append(";");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.mProtocolName.hashCode();
    }

    public boolean equals(Object another) {
        if (another instanceof ProtocolData) {
            return this.getProtocolName().equals(((ProtocolData)another).getProtocolName());
        }
        return false;
    }
}

