/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.jgroups.blocks.DistributedQueue;
import org.jgroups.log.Trace;

public class DistributedQueueBasicTest
extends TestCase {
    static Logger logger = Logger.getLogger((String)(class$org$jgroups$blocks$DistributedQueueBasicTest == null ? (class$org$jgroups$blocks$DistributedQueueBasicTest = DistributedQueueBasicTest.class$("org.jgroups.blocks.DistributedQueueBasicTest")) : class$org$jgroups$blocks$DistributedQueueBasicTest).getName());
    String props;
    protected DistributedQueue tQueue1;
    protected DistributedQueue tQueue2;
    protected static boolean logConfigured;
    static /* synthetic */ Class class$org$jgroups$blocks$DistributedQueueBasicTest;

    public DistributedQueueBasicTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(class$org$jgroups$blocks$DistributedQueueBasicTest == null ? (class$org$jgroups$blocks$DistributedQueueBasicTest = DistributedQueueBasicTest.class$("org.jgroups.blocks.DistributedQueueBasicTest")) : class$org$jgroups$blocks$DistributedQueueBasicTest);
    }

    public void setUp() throws Exception {
        this.props = "UDP(mcast_recv_buf_size=80000;mcast_send_buf_size=150000;mcast_port=45566;mcast_addr=228.8.8.8;ip_ttl=32):PING(timeout=2000;num_initial_members=3):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=600,1200,2000,2500):FRAG(frag_size=8096;down_thread=false;up_thread=false):TOTAL_TOKEN(unblock_sending=10;block_sending=50):pbcast.GMS(print_local_addr=true;join_timeout=3000;join_retry_timeout=2000;shun=true):STATE_TRANSFER:QUEUE";
        Trace.init();
        this.tQueue1 = new DistributedQueue("basic", null, this.props, 5000L);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.tQueue2 = new DistributedQueue("basic", null, this.props, 5000L);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        this.tQueue2.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tQueue1.stop();
    }

    public void test() throws Exception {
        FetchTask t1 = new FetchTask("Queue1", this.tQueue1);
        FetchTask t2 = new FetchTask("Queue2", this.tQueue2);
        Thread rTask1 = new Thread(t1);
        Thread rTask2 = new Thread(t2);
        String obj1 = "object1";
        String obj2 = "object2";
        String obj3 = "object3";
        this.tQueue1.add(obj1);
        this.tQueue1.add(obj2);
        this.tQueue1.add(obj3);
        rTask1.start();
        rTask2.start();
        while (!t1.finished() || !t2.finished()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {}
        }
        String obj = (String)this.tQueue2.remove();
        DistributedQueueBasicTest.assertEquals((String)obj3, (String)obj);
        logger.debug((Object)("Removed from Queue2:" + obj));
        obj = (String)this.tQueue2.remove();
        DistributedQueueBasicTest.assertNull((Object)obj);
        logger.debug((Object)("Removed from Queue2:" + obj));
        obj = (String)this.tQueue2.remove();
        DistributedQueueBasicTest.assertNull((Object)obj);
        logger.debug((Object)("Removed from Queue2:" + obj));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DistributedQueueBasicTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FetchTask
    implements Runnable {
        protected DistributedQueue queue;
        protected String name;
        String r;
        protected boolean finished;

        public FetchTask(String name, DistributedQueue q) {
            this.queue = q;
            this.name = name;
            this.finished = false;
        }

        public void run() {
            this.r = (String)this.queue.remove();
            logger.debug((Object)("Remove from " + this.name + ":" + this.r));
            this.finished = true;
        }

        public String getResult() {
            return this.r;
        }

        public boolean finished() {
            return this.finished;
        }
    }
}

