/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.log.Trace;
import org.jgroups.persistence.CannotPersistException;
import org.jgroups.persistence.CannotRemoveException;
import org.jgroups.persistence.PersistenceFactory;
import org.jgroups.persistence.PersistenceManager;
import org.jgroups.util.Util;

public class DistributedHashtable
extends Hashtable
implements MessageListener,
MembershipListener,
Cloneable {
    private transient Channel channel;
    private transient RpcDispatcher disp = null;
    private transient String groupname = null;
    private transient Vector notifs = new Vector();
    private transient Vector members = new Vector();
    private transient MethodCall put_method = null;
    private transient MethodCall putAll_method = null;
    private transient MethodCall clear_method = null;
    private transient MethodCall remove_method = null;
    private transient boolean persistent = false;
    private transient PersistenceManager persistence_mgr = null;
    private transient boolean send_message = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        this.groupname = groupname;
        this.initMethods();
        this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.setOpt(4, new Boolean(true));
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, boolean persistent, long state_timeout) throws ChannelException {
        this.groupname = groupname;
        this.persistent = persistent;
        this.initMethods();
        this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.setOpt(4, new Boolean(true));
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedHashtable(JChannel channel, long state_timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this(channel, false, state_timeout);
    }

    public DistributedHashtable(JChannel channel, boolean persistent, long state_timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.groupname = channel.getChannelName();
        this.channel = channel;
        this.persistent = persistent;
        this.init(state_timeout);
    }

    protected void init(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        this.initMethods();
        this.channel.setOpt(4, new Boolean(true));
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
    }

    public void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean rc;
        if (this.persistent) {
            Trace.info("DistributedHashtable.initState()", "fetching state from database");
            try {
                this.persistence_mgr = PersistenceFactory.getInstance().createManager();
            }
            catch (Throwable ex) {
                Trace.error("DistributedHashtable.initState()", "failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                this.persistent = false;
            }
        }
        if (rc = this.channel.getState(null, state_timeout)) {
            Trace.info("DistributedHashtable.initState()", "state was retrieved successfully");
        } else {
            Trace.info("DistributedHashtable.initState()", "state could not be retrieved (first member)");
            if (this.persistent) {
                Trace.info("DistributedHashtable.initState()", "fetching state from database");
                try {
                    Map m = this.persistence_mgr.retrieveAll();
                    if (m != null) {
                        Iterator it = m.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            Object key = entry.getKey();
                            Object val = entry.getValue();
                            if (Trace.trace) {
                                Trace.info("DistributedHashtable.initState()", "inserting " + key + " --> " + val);
                            }
                            this.put(key, val);
                        }
                    }
                }
                catch (Throwable ex) {
                    Trace.error("DistributedHashtable.initState()", "failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                    this.persistent = false;
                }
            }
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean p) {
        this.persistent = p;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void removeNotifier(Notification n) {
        if (this.notifs.contains(n)) {
            this.notifs.removeElement(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public Object put(Object key, Object value) {
        Object prev_val = null;
        prev_val = this.get(key);
        if (this.send_message) {
            try {
                this.put_method.setArg(0, key);
                this.put_method.setArg(1, value);
                this.disp.callRemoteMethods(null, this.put_method, 2, 0L);
            }
            catch (Exception e) {}
        } else {
            this._put(key, value);
        }
        return prev_val;
    }

    public void putAll(Map m) {
        if (this.send_message) {
            try {
                this.putAll_method.setArg(0, m);
                this.disp.callRemoteMethods(null, this.putAll_method, 2, 0L);
            }
            catch (Throwable throwable) {}
        } else {
            this._putAll(m);
        }
    }

    public void clear() {
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, this.clear_method, 2, 0L);
            }
            catch (Exception e) {
                Trace.error("DistributedHashtable.clear()", "exception=" + e);
            }
        } else {
            this._clear();
        }
    }

    public Object remove(Object key) {
        Object retval = null;
        retval = this.get(key);
        if (this.send_message) {
            try {
                this.remove_method.setArg(0, key);
                this.disp.callRemoteMethods(null, this.remove_method, 2, 0L);
            }
            catch (Exception exception) {}
        } else {
            this._remove(key);
        }
        return retval;
    }

    public Object _put(Object key, Object value) {
        Object retval = super.put(key, value);
        if (this.persistent) {
            try {
                this.persistence_mgr.save((Serializable)key, (Serializable)value);
            }
            catch (CannotPersistException cannot_persist_ex) {
                Trace.error("DistributedHashtable._put()", "failed persisting " + key + " + " + value + ", exception=" + cannot_persist_ex);
            }
            catch (Throwable t) {
                Trace.error("DistributedHashtable._put()", "failed persisting " + key + " + " + value + ", exception=" + Util.printStackTrace(t));
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entrySet(key, value);
        }
        return retval;
    }

    public void _putAll(Map m) {
        if (m == null) {
            return;
        }
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            super.put(entry.getKey(), entry.getValue());
        }
        if (this.persistent) {
            try {
                this.persistence_mgr.saveAll(m);
            }
            catch (CannotPersistException persist_ex) {
                Trace.error("DistributedHashtable._putAll()", "failed persisting contents: " + persist_ex);
            }
            catch (Throwable t) {
                Trace.error("DistributedHashtable._putAll()", "failed persisting contents: " + t);
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(m);
        }
    }

    public void _clear() {
        super.clear();
        if (this.persistent) {
            try {
                this.persistence_mgr.clear();
            }
            catch (CannotRemoveException cannot_remove_ex) {
                Trace.error("DistributedHashtable._clear()", "failed clearing contents, exception=" + cannot_remove_ex);
            }
            catch (Throwable t) {
                Trace.error("DistributedHashtable._clear()", "failed clearing contents, exception=" + t);
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsCleared();
        }
    }

    public Object _remove(Object key) {
        Object retval = super.remove(key);
        if (this.persistent) {
            try {
                this.persistence_mgr.remove((Serializable)key);
            }
            catch (CannotRemoveException cannot_remove_ex) {
                Trace.error("DistributedHashtable._remove()", "failed clearing contents, exception=" + cannot_remove_ex);
            }
            catch (Throwable t) {
                Trace.error("DistributedHashtable._remove()", "failed clearing contents, exception=" + t);
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryRemoved(key);
        }
        return retval;
    }

    public void receive(Message msg) {
    }

    public byte[] getState() {
        Hashtable copy = new Hashtable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object val = this.get(key);
            copy.put(key, val);
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (Throwable ex) {
            Trace.error("DistributedHashtable.getState()", "exception marshalling state: " + ex);
            return null;
        }
    }

    public void setState(byte[] new_state) {
        Hashtable new_copy;
        try {
            new_copy = (Hashtable)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (Throwable ex) {
            Trace.error("DistributedHashtable.setState()", "exception unmarshalling state: " + ex);
            return;
        }
        this._putAll(new_copy);
    }

    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    void initMethods() {
        try {
            if (this.put_method == null) {
                this.put_method = new MethodCall(this.getClass().getMethod("_put", class$java$lang$Object == null ? (class$java$lang$Object = DistributedHashtable.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = DistributedHashtable.class$("java.lang.Object")) : class$java$lang$Object));
                this.put_method.setNumArgs(2);
            }
            if (this.putAll_method == null) {
                this.putAll_method = new MethodCall(this.getClass().getMethod("_putAll", class$java$util$Map == null ? (class$java$util$Map = DistributedHashtable.class$("java.util.Map")) : class$java$util$Map));
                this.putAll_method.setNumArgs(1);
            }
            if (this.clear_method == null) {
                this.clear_method = new MethodCall(this.getClass().getMethod("_clear", new Class[0]));
            }
            if (this.remove_method == null) {
                this.remove_method = new MethodCall(this.getClass().getMethod("_remove", class$java$lang$Object == null ? (class$java$lang$Object = DistributedHashtable.class$("java.lang.Object")) : class$java$lang$Object));
                this.remove_method.setNumArgs(1);
            }
        }
        catch (Throwable ex) {
            Trace.error("DistributedHashtable.initMethods()", "exception=" + ex);
        }
    }

    public static void main(String[] args) {
        try {
            JChannel c = new JChannel("file:/c:/JGroups-2.0/conf/state_transfer.xml");
            c.setOpt(4, new Boolean(true));
            DistributedHashtable ht = new DistributedHashtable(c, false, 5000L);
            c.connect("demo");
            ht.start(5000L);
            ht.put("name", "Michelle Ban");
            Object old_key = ht.remove("name");
            System.out.println("old key was " + old_key);
            ht.put("newkey", "newvalue");
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("k1", "v1");
            m.put("k2", "v2");
            ht.putAll(m);
            System.out.println("hashmap is " + ht);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsSet(Map var1);

        public void contentsCleared();
    }
}

