/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.log.Trace;
import org.jgroups.util.Marshaller;

public class Message
implements Externalizable {
    protected Address dest_addr = null;
    protected Address src_addr = null;
    protected byte[] buf = null;
    protected HashMap headers = null;
    static final long ADDRESS_OVERHEAD = 200L;
    static final long serialVersionUID = -1137364035832847034L;

    public Message(Address dest, Address src, byte[] buf) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.buf = buf;
    }

    public Message(Address dest, Address src, Serializable obj) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setObject(obj);
    }

    public Message() {
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void setBuffer(byte[] b) {
        this.buf = b;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream(256);
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            this.buf = out_stream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            Trace.error("Message.setObject()", "exception=" + e);
        }
    }

    public Object getObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.buf);
            ObjectInputStream in = new ObjectInputStream(in_stream);
            return in.readObject();
        }
        catch (Exception e) {
            Trace.error("Message.getObject()", "exception=" + e);
            return null;
        }
    }

    public void reset() {
        this.src_addr = null;
        this.dest_addr = null;
        this.buf = null;
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void putHeader(String key, Header hdr) {
        this.headers().put(key, hdr);
    }

    public Header removeHeader(String key) {
        return this.headers != null ? (Header)this.headers.remove(key) : null;
    }

    public void removeHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public Header getHeader(String key) {
        return this.headers != null ? (Header)this.headers.get(key) : null;
    }

    public Message copy() {
        Message retval = new Message();
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        if (this.buf != null) {
            retval.buf = this.buf;
        }
        if (this.headers != null) {
            retval.headers = (HashMap)this.headers.clone();
        }
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr, null, null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        if (this.headers != null && this.headers.size() > 0) {
            ret.append(" (" + this.headers.size() + " headers)");
        }
        ret.append(", size = ");
        if (this.buf != null && this.buf.length > 0) {
            ret.append(this.buf.length);
        } else {
            ret.append("0");
        }
        ret.append(" bytes");
        ret.append("]");
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = this.buf != null ? (long)this.buf.length : 0L;
        long hdr_size = 0L;
        if (this.dest_addr != null) {
            retval += 200L;
        }
        if (this.src_addr != null) {
            retval += 200L;
        }
        if (this.headers != null) {
            Iterator it = this.headers.values().iterator();
            while (it.hasNext()) {
                Header hdr = (Header)it.next();
                if (hdr == null) continue;
                hdr_size = hdr.size();
                if (hdr_size <= 0L) {
                    hdr_size = 255L;
                    continue;
                }
                retval += hdr_size;
            }
        }
        return retval;
    }

    public String printObjectHeaders() {
        StringBuffer sb = new StringBuffer();
        if (this.headers != null) {
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dest_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.dest_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.src_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.src_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.buf == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.buf.length);
            out.write(this.buf);
        }
        if (this.headers == null) {
            out.writeInt(0);
        } else {
            int len = this.headers.size();
            out.writeInt(len);
            Iterator it = this.headers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                out.writeUTF((String)entry.getKey());
                Externalizable hdr = (Externalizable)entry.getValue();
                Marshaller.write(hdr, out);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len;
        int i;
        boolean srcAddressExist;
        boolean destAddressExist = in.readBoolean();
        if (destAddressExist) {
            this.dest_addr = (Address)Marshaller.read(in);
        }
        if (srcAddressExist = in.readBoolean()) {
            this.src_addr = (Address)Marshaller.read(in);
        }
        if ((i = in.readInt()) != 0) {
            this.buf = new byte[i];
            in.readFully(this.buf);
        }
        if ((len = in.readInt()) > 0) {
            this.headers = new HashMap();
        }
        while (len-- > 0) {
            String key = in.readUTF();
            Externalizable value = Marshaller.read(in);
            this.headers.put(key, value);
        }
    }

    HashMap headers() {
        return this.headers != null ? this.headers : (this.headers = new HashMap());
    }
}

