/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.log.Trace;

public class Membership
implements Cloneable {
    private Vector members = null;

    public Membership() {
        this.members = new Vector(11);
    }

    public Membership(Vector initial_members) {
        if (initial_members != null) {
            this.members = (Vector)initial_members.clone();
        }
    }

    public Vector getMembers() {
        return (Vector)this.members.clone();
    }

    public synchronized void add(Address new_member) {
        if (new_member != null && !this.members.contains(new_member)) {
            this.members.addElement(new_member);
        }
    }

    public synchronized void add(Vector v) {
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                this.add((Address)v.elementAt(i));
            }
        }
    }

    public synchronized void remove(Address old_member) {
        if (old_member != null) {
            this.members.remove(old_member);
        }
    }

    public synchronized void remove(Vector v) {
        if (v != null) {
            this.members.removeAll(v);
        }
    }

    public synchronized void clear() {
        this.members.removeAllElements();
    }

    public synchronized void set(Vector v) {
        this.clear();
        if (v != null) {
            this.add(v);
        }
    }

    public synchronized void set(Membership m) {
        this.clear();
        if (m != null) {
            this.add(m.getMembers());
        }
    }

    public synchronized void merge(Vector new_mems, Vector suspects) {
        this.remove(suspects);
        this.add(new_mems);
    }

    public synchronized boolean contains(Address member) {
        if (member == null) {
            return false;
        }
        return this.members.contains(member);
    }

    public synchronized void sort() {
        for (int j = 0; j < this.members.size(); ++j) {
            for (int i = 0; i < this.members.size() - 1; ++i) {
                Address a1 = (Address)this.members.elementAt(i);
                Address a2 = (Address)this.members.elementAt(i + 1);
                if (a1 == null || a2 == null) {
                    Trace.error("Membership.sort()", "member's address is null");
                    continue;
                }
                if (a1.compareTo(a2) <= 0) continue;
                Address tmp = a2;
                this.members.setElementAt(a1, i + 1);
                this.members.setElementAt(tmp, i);
            }
        }
    }

    public synchronized Membership copy() {
        return (Membership)this.clone();
    }

    public synchronized Object clone() {
        try {
            Membership m = (Membership)super.clone();
            m.members = (Vector)this.members.clone();
            return m;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public synchronized int size() {
        return this.members.size();
    }

    public synchronized Object elementAt(int index) {
        return this.members.elementAt(index);
    }

    public synchronized String toString() {
        return this.members.toString();
    }
}

