/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.tools;

import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.tools.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.kxml.Attribute;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.Tag;
import org.kxml.parser.XmlParser;
import org.kxml.wap.SyncMLParser;
import org.kxml.wap.SyncMLWriter;
import org.kxml.wap.WapExtensionEvent;

public class WBXMLTools {
    public static final String WELL_KNOWN_NS = ",DevInf,SyncML,MgmtTree,";

    public static byte[] toWBXML(String s, String verDTD) throws Sync4jException {
        SyncMLWriter writer = null;
        try {
            XmlParser xml = new XmlParser((Reader)new StringReader(s));
            boolean[] inTag = new boolean[5];
            writer = WBXMLTools.traverseXML(xml, null, inTag, verDTD);
        }
        catch (IOException e) {
            throw new Sync4jException(e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return writer.getBytes();
    }

    public static byte[] toWBXML(String s) throws Sync4jException {
        SyncMLWriter writer = null;
        try {
            XmlParser xml = new XmlParser((Reader)new StringReader(s));
            boolean[] inTag = new boolean[5];
            writer = WBXMLTools.traverseXML(xml, null, inTag, null);
        }
        catch (IOException e) {
            throw new Sync4jException(e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return writer.getBytes();
    }

    public static byte[] toWBXML(SyncML msg) throws Sync4jException {
        String verDTD = msg.getSyncHdr().getVerDTD().getValue();
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IBindingFactory f = BindingDirectory.getFactory(SyncML.class);
            IMarshallingContext c = f.createMarshallingContext();
            c.setIndent(0);
            c.marshalDocument((Object)msg, "UTF-8", null, (OutputStream)bout);
            String inputXml = new String(bout.toByteArray());
            return WBXMLTools.toWBXML(inputXml, verDTD);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String wbxmlToXml(byte[] msg) throws Sync4jException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(msg);
            SyncMLParser parser = new SyncMLParser((InputStream)in);
            return WBXMLTools.parseWBXML(parser);
        }
        catch (Throwable t) {
            throw new Sync4jException(t.getMessage(), t);
        }
    }

    public static boolean isWellKnownNamespace(String ns) {
        return WELL_KNOWN_NS.indexOf(',' + ns + ',') >= 0;
    }

    private static SyncMLWriter traverseXML(XmlParser parser, SyncMLWriter writer, boolean[] inTag, String verDTD) throws IOException {
        boolean leave = false;
        do {
            ParseEvent event = parser.read();
            String tagName = event.getName();
            String nameSpace = null;
            switch (event.getType()) {
                case 64: {
                    SyncMLWriter tagWriter = null;
                    if (!inTag[0]) {
                        inTag[0] = "Item".equals(tagName);
                        inTag[3] = false;
                    }
                    if (inTag[0] && !inTag[1]) {
                        inTag[1] = "Meta".equals(tagName);
                    }
                    if (inTag[0] && inTag[1] && !inTag[2]) {
                        inTag[2] = "Format".equals(tagName);
                    }
                    if (inTag[0] && !inTag[3]) {
                        inTag[3] = "Data".equals(tagName);
                    }
                    nameSpace = ((Tag)event).getNamespace();
                    if (WBXMLTools.isWellKnownNamespace(tagName)) {
                        tagWriter = new SyncMLWriter(nameSpace, verDTD);
                        if (writer == null) {
                            writer = tagWriter;
                        }
                    } else {
                        tagWriter = writer;
                    }
                    tagWriter.startTag(tagName);
                    WBXMLTools.traverseXML(parser, tagWriter, inTag, verDTD);
                    if (tagWriter == writer) break;
                    tagWriter.close();
                    writer.writeOpaque(new String(tagWriter.getBytes()));
                    tagWriter = null;
                    break;
                }
                case 16: {
                    if ("Item".equals(tagName) && inTag[0]) {
                        inTag[0] = false;
                    }
                    if ("Meta".equals(tagName) && inTag[1]) {
                        inTag[1] = false;
                    }
                    if ("Format".equals(tagName) && inTag[2]) {
                        inTag[2] = false;
                    }
                    if ("Data".equals(tagName) && inTag[3]) {
                        inTag[3] = false;
                        inTag[4] = false;
                    }
                    writer.endTag();
                    leave = true;
                    break;
                }
                case 8: {
                    leave = true;
                    break;
                }
                case 128: {
                    String text = event.getText();
                    if (inTag[2] && "b64".equalsIgnoreCase(text)) {
                        text = "bin";
                        inTag[4] = true;
                    }
                    if (inTag[3] && inTag[4]) {
                        byte[] bytes = Base64.decode(text.getBytes());
                        writer.write(bytes);
                        break;
                    }
                    writer.write(text);
                    break;
                }
                case 256: {
                    break;
                }
            }
        } while (!leave);
        return writer;
    }

    private static String parseWBXML(SyncMLParser parser) throws IOException {
        boolean[] inTag = new boolean[9];
        return WBXMLTools.parseWBXML(parser, inTag);
    }

    private static String parseWBXML(SyncMLParser parser, boolean[] inTag) throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean leave = false;
        String tagName = null;
        String text = null;
        do {
            ParseEvent event = parser.read();
            tagName = event.getName();
            switch (event.getType()) {
                case 64: {
                    tagName = event.getName();
                    buf.append("<");
                    buf.append(tagName);
                    List attrs = event.getAttributes();
                    if (attrs != null) {
                        for (int i = 0; i < attrs.size(); ++i) {
                            Attribute attr = (Attribute)attrs.get(i);
                            buf.append(" ");
                            buf.append(attr.getName());
                            buf.append("='");
                            buf.append(attr.getValue());
                            buf.append("'");
                        }
                    }
                    buf.append(">");
                    if (!inTag[0]) {
                        boolean bl = inTag[0] = "Put".equals(tagName) || "Results".equals(tagName);
                    }
                    if (!inTag[1]) {
                        inTag[1] = "Item".equals(tagName);
                    } else if (inTag[1]) {
                        inTag[2] = "Data".equals(tagName);
                    }
                    if (!inTag[6]) {
                        inTag[6] = "Item".equals(tagName);
                    }
                    if (inTag[6] && !inTag[7]) {
                        inTag[7] = "Data".equals(tagName);
                    }
                    if (!inTag[3]) {
                        inTag[3] = "Cred".equals(tagName);
                    }
                    text = WBXMLTools.parseWBXML(parser, inTag);
                    if (inTag[6] && "Meta".equals(tagName)) {
                        inTag[8] = text.indexOf("bin") >= 0;
                        text = text.replaceAll("bin", "b64");
                    }
                    if (inTag[3] && "Meta".equals(tagName)) {
                        inTag[4] = text.indexOf("b64") >= 0;
                        inTag[5] = text.indexOf("auth-md5") >= 0;
                        buf.append(text);
                        text = WBXMLTools.parseWBXML(parser, inTag);
                    }
                    buf.append(text);
                    break;
                }
                case 16: {
                    if (tagName != null) {
                        if (tagName.equals("Put")) {
                            if (inTag[0]) {
                                inTag[0] = false;
                            }
                        } else if (tagName.equals("Results")) {
                            if (inTag[0]) {
                                inTag[0] = false;
                            }
                        } else if (tagName.equals("Cred")) {
                            if (inTag[3]) {
                                inTag[3] = false;
                            }
                        } else if (tagName.equals("Item")) {
                            if (inTag[6]) {
                                inTag[6] = false;
                            }
                            if (inTag[1]) {
                                inTag[1] = false;
                            }
                        } else if (tagName.equals("Data")) {
                            if (inTag[7]) {
                                inTag[7] = false;
                                inTag[8] = false;
                            }
                            if (inTag[2]) {
                                inTag[2] = false;
                            }
                        }
                    }
                    buf.append("</");
                    buf.append(event.getName());
                    buf.append(">");
                    leave = true;
                    break;
                }
                case 8: {
                    leave = true;
                    break;
                }
                case 128: {
                    text = event.getText();
                    text = WBXMLTools.replaceDataContent(text);
                    buf.append(text);
                    break;
                }
                case 1024: {
                    text = event.getText();
                    if (!inTag[0] && inTag[1] && inTag[2]) {
                        text = WBXMLTools.replaceDataContent(text);
                    }
                    if (event instanceof WapExtensionEvent) {
                        WapExtensionEvent e = (WapExtensionEvent)event;
                        Object content = e.getContent();
                        if (inTag[5] && !inTag[4] && content != null && content instanceof byte[]) {
                            text = new String(Base64.encode((byte[])content));
                        }
                        if (inTag[8] && content instanceof byte[]) {
                            text = new String(Base64.encode((byte[])content));
                        }
                        if (((WapExtensionEvent)event).getId() == 195) {
                            text = WBXMLTools.replaceDataContent(text);
                        }
                    }
                    buf.append(text);
                    break;
                }
                case 256: {
                    break;
                }
            }
        } while (!leave);
        return buf.toString();
    }

    private static String replaceDataContent(String text) {
        text = StringUtils.replace((String)text, (String)"&", (String)"&amp;");
        text = StringUtils.replace((String)text, (String)"<", (String)"&lt;");
        text = StringUtils.replace((String)text, (String)">", (String)"&gt;");
        text = StringUtils.replace((String)text, (String)"\"", (String)"&quot;");
        return text;
    }
}

