/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server.store;

import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.PreparedWhere;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.builder.ToStringBuilder;

public class LogicalClause
extends Clause
implements Serializable {
    public static final String OPT_AND = "AND";
    public static final String OPT_OR = "OR";
    public static final String OPT_NOT = "NOT";
    private String operator;
    private Clause[] operands;

    protected LogicalClause() {
    }

    public LogicalClause(String operator, Clause[] operands) {
        if (!(OPT_AND.equalsIgnoreCase(operator) || OPT_OR.equalsIgnoreCase(operator) || OPT_NOT.equalsIgnoreCase(operator))) {
            throw new IllegalArgumentException("operator " + operator + " not supported; it must be one of (" + OPT_AND + "," + OPT_OR + "," + OPT_NOT + ")");
        }
        if (operands == null) {
            throw new NullPointerException("operands is null!");
        }
        if (OPT_NOT.equalsIgnoreCase(operator)) {
            if (operands.length != 1) {
                throw new IllegalArgumentException("one and only one operand is required with NOT");
            }
        } else if (operands.length < 2) {
            throw new IllegalArgumentException("two or more operands are required with AND or OR");
        }
        this.operator = operator;
        this.operands = operands;
    }

    public String getOperator() {
        return this.operator;
    }

    @Override
    public PreparedWhere getPreparedWhere() {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        PreparedWhere pw = null;
        if (this.isUnaryOperator()) {
            pw = this.operands[0].getPreparedWhere();
            sql.append(this.operator.toLowerCase()).append(pw.sql);
            for (i = 0; i < pw.parameters.length; ++i) {
                parameters.add(pw.parameters[i]);
            }
        } else {
            for (i = 0; i < this.operands.length; ++i) {
                pw = this.operands[i].getPreparedWhere();
                if (i > 0) {
                    sql.append(' ').append(this.operator.toLowerCase()).append(' ');
                }
                sql.append(pw.sql);
                for (int j = 0; j < pw.parameters.length; ++j) {
                    parameters.add(pw.parameters[j]);
                }
            }
        }
        PreparedWhere ret = new PreparedWhere();
        ret.sql = '(' + sql.toString() + ')';
        ret.parameters = parameters.toArray();
        return ret;
    }

    private boolean isUnaryOperator() {
        return OPT_NOT.equalsIgnoreCase(this.operator);
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("operator:", (Object)this.operator);
        return sb.toString();
    }
}

