/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.notification;

import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.dm.bootstrap.WapProvisioningDoc;
import com.funambol.framework.tools.Base64;
import com.funambol.server.notification.WapProvisioningDocParser;
import com.funambol.server.notification.WapProvisioningDocWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.kxml.Attribute;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;
import org.kxml.wap.WapExtensionEvent;

public class WBXMLTools {
    public static byte[] toWBXML(String s) throws Sync4jException {
        WapProvisioningDocWriter writer = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer = new WapProvisioningDocWriter(out);
            XmlParser xml = new XmlParser((Reader)new StringReader(s));
            WBXMLTools.traverseXML(xml, writer);
        }
        catch (IOException e) {
            throw new Sync4jException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return out.toByteArray();
    }

    public static byte[] toWBXML(WapProvisioningDoc msg) throws Exception {
        return WBXMLTools.toWBXML(msg.toXml());
    }

    private static void traverseXML(XmlParser parser, WapProvisioningDocWriter writer) throws IOException {
        boolean leave = false;
        do {
            ParseEvent event = parser.read();
            switch (event.getType()) {
                case 64: {
                    WapProvisioningDocWriter tagWriter = null;
                    String name = event.getName();
                    tagWriter = writer;
                    tagWriter.startTag(name);
                    List attributes = event.getAttributes();
                    if (attributes != null) {
                        int numAttr = attributes.size();
                        Attribute attr = null;
                        for (int i = 0; i < numAttr; ++i) {
                            attr = event.getAttribute(i);
                            tagWriter.attribute(attr.getName(), attr.getValue());
                        }
                    }
                    WBXMLTools.traverseXML(parser, tagWriter);
                    break;
                }
                case 16: {
                    writer.endTag();
                    leave = true;
                    break;
                }
                case 8: {
                    leave = true;
                    break;
                }
                case 128: {
                    writer.write(event.getText());
                    break;
                }
                case 256: {
                    break;
                }
            }
        } while (!leave);
    }

    public static String wbxmlToXml(byte[] msg) throws Sync4jException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(msg);
            WapProvisioningDocParser parser = new WapProvisioningDocParser(in);
            return WBXMLTools.parseWBXML(parser);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Sync4jException(t.getMessage(), t);
        }
    }

    private static String parseWBXML(WapProvisioningDocParser parser) throws IOException {
        return WBXMLTools.parseWBXML(parser, false, false, false);
    }

    private static String parseWBXML(WapProvisioningDocParser parser, boolean inCred, boolean b64, boolean auth_md5) throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean leave = false;
        String tagName = null;
        String text = null;
        do {
            ParseEvent event = parser.read();
            switch (event.getType()) {
                case 64: {
                    tagName = event.getName();
                    buf.append("<");
                    buf.append(tagName);
                    List attrs = event.getAttributes();
                    if (attrs != null) {
                        for (int i = 0; i < attrs.size(); ++i) {
                            Attribute attr = (Attribute)attrs.get(i);
                            buf.append(" ");
                            buf.append(attr.getName());
                            buf.append("='");
                            buf.append(attr.getValue());
                            buf.append("'");
                        }
                    }
                    buf.append(">");
                    text = !inCred ? WBXMLTools.parseWBXML(parser, "Cred".equals(tagName), false, false) : WBXMLTools.parseWBXML(parser, true, b64, auth_md5);
                    if (inCred && "Meta".equals(tagName)) {
                        b64 = text.indexOf("b64") >= 0;
                        auth_md5 = text.indexOf("auth-md5") >= 0;
                        buf.append(text);
                        text = WBXMLTools.parseWBXML(parser, true, b64, auth_md5);
                    }
                    buf.append(text);
                    break;
                }
                case 16: {
                    buf.append("</");
                    buf.append(event.getName());
                    buf.append(">");
                    leave = true;
                    break;
                }
                case 8: {
                    leave = true;
                    break;
                }
                case 128: {
                    buf.append(event.getText());
                    break;
                }
                case 1024: {
                    text = event.getText();
                    if (event instanceof WapExtensionEvent) {
                        WapExtensionEvent e = (WapExtensionEvent)event;
                        Object content = e.getContent();
                        if (auth_md5 && !b64 && content != null && content instanceof byte[]) {
                            text = new String(Base64.encode((byte[])((byte[])content)));
                        }
                    }
                    buf.append(text);
                    break;
                }
                case 256: {
                    break;
                }
            }
        } while (!leave);
        return buf.toString();
    }
}

