/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.notification;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.core.dm.bootstrap.BasicAccountInfo;
import com.funambol.framework.core.dm.bootstrap.BootStrap;
import com.funambol.framework.notification.AbstractNotificationEngine;
import com.funambol.framework.notification.BootStrapSender;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.notification.NotificationMessageBuilder;
import com.funambol.framework.notification.NotificationSender;
import com.funambol.framework.tools.DbgTools;
import com.funambol.framework.tools.SecurityTools;
import com.funambol.framework.tools.beans.BeanFactory;
import com.funambol.server.bootstrap.DMBootstrapMessageBuilder;
import com.funambol.server.bootstrap.PlainBootstrapMessageBuilder;
import com.funambol.server.bootstrap.WapBootstrapMessageBuilder;
import com.funambol.server.notification.GenericNotificationMessageBuilder;
import java.security.GeneralSecurityException;
import org.jboss.logging.Logger;

public class NotificationEngineImpl
extends AbstractNotificationEngine {
    private static final float SYNCML_DM_PROTOCOL_VERSION = 1.1f;
    public static final String NOTIFICATION_SENDER_BEAN = "com/funambol/server/engine/dm/NotificationSender.xml";
    public static final String BOOTSTRAP_SENDER_BEAN = "com/funambol/server/engine/dm/BootstrapSender.xml";
    private static final transient Logger log = Logger.getLogger((String)NotificationEngineImpl.class.getName());
    private Configuration config = null;

    public NotificationEngineImpl(Configuration config) {
        super(config);
        this.config = config;
    }

    public void sendNotificationMessage(int messageType, int transportType, int sessionId, String phoneNumber, String info, String serverId, String serverPassword, byte[] serverNonce) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("sendNotificationMessage with: \n- messageType: " + messageType + "\n- transportType: " + transportType + "\n- sessionId: " + sessionId + "\n- phoneNumber: " + phoneNumber + "\n- info: " + info + "\n- serverId: " + serverId + "\n- serverPassword: " + serverPassword + "\n- serverNonce: " + serverNonce));
        }
        NotificationMessageBuilder messageBuilder = null;
        NotificationSender messageSender = null;
        messageBuilder = this.getNotificationMessageBuilder(messageType);
        messageSender = this.getNotificationSender();
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("NotificationMessageBuilder: " + messageBuilder));
            log.trace((Object)("Sender: " + messageSender));
        }
        byte[] message = messageBuilder.buildMessage(sessionId, phoneNumber, serverId, serverPassword, serverNonce, 1.1f);
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Notification message to send: " + DbgTools.bytesToHex((byte[])message)));
        }
        messageSender.sendMessages(messageType, new String[]{phoneNumber}, (byte[][])new byte[][]{message}, info);
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Notification message to " + phoneNumber + " sent"));
        }
    }

    public void sendNotificationMessages(int messageType, int transportType, int[] sessionIds, String[] phoneNumbers, String info, String serverId, String[] serverPasswords, byte[][] serverNonces) throws NotificationException {
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("sendNotificationMessages with: \n- messageType: " + messageType + "\n- transportType: " + transportType + "\n- info: " + info + "\n- serverId: " + serverId));
        }
        NotificationMessageBuilder messageBuilder = null;
        NotificationSender messageSender = null;
        messageBuilder = this.getNotificationMessageBuilder(messageType);
        messageSender = this.getNotificationSender();
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("NotificationMessageBuilder: " + messageBuilder));
            log.trace((Object)("Sender: " + messageSender));
        }
        int numDevices = phoneNumbers.length;
        byte[][] messages = new byte[numDevices][];
        for (int i = 0; i < numDevices; ++i) {
            messages[i] = messageBuilder.buildMessage(sessionIds[i], phoneNumbers[i], serverId, serverPasswords[i], serverNonces[i], 1.1f);
            if (!log.isEnabled(Logger.Level.TRACE)) continue;
            log.trace((Object)("Notification message to send to " + phoneNumbers[i] + ": " + DbgTools.bytesToHex((byte[])messages[i])));
        }
        messageSender.sendMessages(messageType, phoneNumbers, (byte[][])messages, info);
        if (log.isEnabled(Logger.Level.INFO)) {
            log.info((Object)("Notification message sent to " + phoneNumbers.length + " devices"));
        }
    }

    public void bootstrap(BasicAccountInfo[] basicAccountsInfo, BootStrap[] bootstraps) throws NotificationException {
        if (basicAccountsInfo == null) {
            throw new NotificationException("Unable to start the bootstrap process. The given basicAccountsInfo is null");
        }
        if (bootstraps == null) {
            throw new NotificationException("Unable to start the bootstrap process. The given bootstraps is null");
        }
        int numDevices = bootstraps.length;
        int numBasicAccounts = basicAccountsInfo.length;
        if (numDevices != numBasicAccounts) {
            throw new NotificationException("Unable to start the bootstrap process. The number of the bootstrap objects (" + numDevices + ") is different from the number of the basicAccountInfo objects (" + numBasicAccounts + ")");
        }
        BootStrapSender bootstrapSender = this.getBootStrapSender();
        byte[][] messages = new byte[numDevices][];
        String[] macs = new String[numDevices];
        int[] authMethods = new int[numDevices];
        String[] phoneNumbers = new String[numDevices];
        int[] messageTypes = new int[numDevices];
        String[] info = new String[numDevices];
        for (int i = 0; i < numDevices; ++i) {
            phoneNumbers[i] = bootstraps[i].getMsisdn();
            messageTypes[i] = bootstraps[i].getMessageType();
            switch (messageTypes[i]) {
                case 1: {
                    PlainBootstrapMessageBuilder plainBuilder = new PlainBootstrapMessageBuilder();
                    messages[i] = plainBuilder.buildMessage(basicAccountsInfo[i], bootstraps[i].getNodes());
                    break;
                }
                case 0: {
                    WapBootstrapMessageBuilder wapBuilder = new WapBootstrapMessageBuilder();
                    messages[i] = wapBuilder.buildMessage(basicAccountsInfo[i], bootstraps[i].getWapProvisioningDoc());
                    break;
                }
                case 2: {
                    DMBootstrapMessageBuilder dmBuilder = new DMBootstrapMessageBuilder();
                    messages[i] = dmBuilder.buildMessage(basicAccountsInfo[i], bootstraps[i].getMgmtTree());
                    break;
                }
                default: {
                    throw new NotificationException("Message type not supported");
                }
            }
            info[i] = bootstraps[i].getInfo();
            authMethods[i] = bootstraps[i].getAuthMethod();
            macs[i] = bootstraps[i].getDigest();
            if (macs[i] == null) {
                macs[i] = this.computeMac(authMethods[i], messages[i], bootstraps[i].getImsi(), bootstraps[i].getUserPin(), bootstraps[i].isImsiInSemiOctet());
            }
            if (!log.isEnabled(Logger.Level.TRACE)) continue;
            log.trace((Object)("Bootstrap message to send: " + messages[i] + " (length: " + messages[i].length + ")"));
        }
        bootstrapSender.sendMessages(messageTypes, macs, authMethods, phoneNumbers, (byte[][])messages, info);
    }

    private String computeMac(int authMethod, byte[] message, String imsi, String userPin, boolean imsiInSemiOctet) throws NotificationException {
        String mac = null;
        if (authMethod == 0) {
            if (imsiInSemiOctet) {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Compute mac using imsi in semi-octect");
                }
                mac = this.computeMac(NotificationEngineImpl.getKeyFromIMSI(imsi), message);
            } else {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Compute mac using imsi in textplain");
                }
                mac = this.computeMac(imsi.getBytes(), message);
            }
        } else if (authMethod == 1) {
            byte[] key = null;
            if (userPin == null) {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Try using USERPIN but userPin is null. Uses imsi to calculate the MAC ");
                }
                if (imsi == null) {
                    if (log.isEnabled(Logger.Level.TRACE)) {
                        log.trace((Object)"Try using USERPIN but userPin and imsi are null");
                    }
                    throw new NotificationException("Userpin or imsi must be not null using USERPIN authentication method");
                }
                if (imsiInSemiOctet) {
                    if (log.isEnabled(Logger.Level.TRACE)) {
                        log.trace((Object)"Compute mac using imsi in semi-octect");
                    }
                    key = NotificationEngineImpl.getKeyFromIMSI(imsi);
                } else {
                    if (log.isEnabled(Logger.Level.TRACE)) {
                        log.trace((Object)"Compute mac using imsi in textplain");
                    }
                    key = imsi.getBytes();
                }
            } else {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Compute mac using user pin");
                }
                key = userPin.getBytes();
            }
            mac = this.computeMac(key, message);
        } else if (authMethod == 2) {
            byte[] imsiKey = null;
            if (imsiInSemiOctet) {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Compute mac using imsi (in semi-octect) and user pin");
                }
                imsiKey = NotificationEngineImpl.getKeyFromIMSI(imsi);
            } else {
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)"Compute mac using imsi (in text-plain) and user pin");
                }
                imsiKey = imsi.getBytes();
            }
            int imsiKeyLength = imsiKey.length;
            byte[] userPinKey = userPin.getBytes();
            int userPinKeyLength = userPinKey.length;
            byte[] key = new byte[imsiKeyLength + userPinKeyLength];
            System.arraycopy(imsiKey, 0, key, 0, imsiKeyLength);
            System.arraycopy(userPinKey, 0, key, imsiKeyLength, userPinKeyLength);
            mac = this.computeMac(key, message);
        }
        return mac;
    }

    private NotificationSender getNotificationSender() throws NotificationException {
        NotificationSender messageSender = null;
        ClassLoader classLoader = this.config.getClassLoader();
        try {
            messageSender = (NotificationSender)BeanFactory.getBeanInstance((ClassLoader)classLoader, (String)NOTIFICATION_SENDER_BEAN);
        }
        catch (Exception ex) {
            log.debug((Object)"getSender", (Throwable)ex);
            throw new NotificationException("Error reading the sender", (Throwable)ex);
        }
        return messageSender;
    }

    private BootStrapSender getBootStrapSender() throws NotificationException {
        BootStrapSender messageSender = null;
        ClassLoader classLoader = this.config.getClassLoader();
        try {
            messageSender = (BootStrapSender)BeanFactory.getBeanInstance((ClassLoader)classLoader, (String)BOOTSTRAP_SENDER_BEAN);
        }
        catch (Exception ex) {
            log.debug((Object)"getSender", (Throwable)ex);
            throw new NotificationException("Error reading the sender", (Throwable)ex);
        }
        return messageSender;
    }

    private NotificationMessageBuilder getNotificationMessageBuilder(int messageType) throws NotificationException {
        GenericNotificationMessageBuilder messageBuilder = null;
        switch (messageType) {
            case 0: {
                messageBuilder = new GenericNotificationMessageBuilder();
                break;
            }
            default: {
                throw new NotificationException("Message type not supported");
            }
        }
        return messageBuilder;
    }

    private String computeMac(byte[] key, byte[] message) throws NotificationException {
        byte[] bMac = null;
        try {
            bMac = SecurityTools.computeHmacSha1((byte[])key, (byte[])message);
        }
        catch (GeneralSecurityException e) {
            throw new NotificationException("Error computing the mac", (Throwable)e);
        }
        String mac = NotificationEngineImpl.bytesToHex(bMac);
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Mac: " + mac));
        }
        return mac;
    }

    private static String bytesToHex(byte[] b) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < b.length; ++i) {
            buf.append(NotificationEngineImpl.byteToHex(b[i]));
        }
        return buf.toString();
    }

    private static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    private static byte[] getKeyFromIMSI(String imsi) throws NotificationException {
        imsi = imsi.trim();
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("IMSI: " + imsi));
        }
        if (imsi.length() % 2 == 1) {
            imsi = "9" + imsi;
        } else {
            imsi = "1" + imsi;
            imsi = imsi + "F";
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("IMSI updated: " + imsi));
        }
        int numDigit = imsi.length();
        String temp = null;
        char c1 = '\u0000';
        char c2 = '\u0000';
        byte[] key = new byte[numDigit / 2];
        int t = 0;
        for (int i = 0; i < numDigit; ++i) {
            c1 = imsi.charAt(i);
            c2 = imsi.charAt(++i);
            temp = "" + c2 + c1;
            try {
                key[t] = (byte)Integer.parseInt(temp, 16);
            }
            catch (NumberFormatException ex) {
                throw new NotificationException("IMSI isn't valid (only numbers are permitted)");
            }
            ++t;
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Key from imsi: " + NotificationEngineImpl.bytesToHex(key)));
        }
        return key;
    }
}

