/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;

public class Utility {
    private Utility() {
    }

    private static void recursePathJars(String path, ArrayList paths) {
        try {
            Attributes attrs;
            String cpath;
            JarFile jfile = new JarFile(path, false);
            Manifest mfst = jfile.getManifest();
            if (mfst != null && (cpath = (String)(attrs = mfst.getMainAttributes()).get(Attributes.Name.CLASS_PATH)) != null) {
                String base;
                int split = path.lastIndexOf(File.separatorChar);
                String string = base = split >= 0 ? path.substring(0, split + 1) : "";
                while (cpath != null) {
                    String ipath;
                    String item;
                    split = cpath.indexOf(32);
                    if (split >= 0) {
                        item = cpath.substring(0, split);
                        cpath = cpath.substring(split + 1).trim();
                    } else {
                        item = cpath;
                        cpath = null;
                    }
                    if (paths.contains(ipath = base + item)) continue;
                    paths.add(ipath);
                    split = ipath.lastIndexOf(46);
                    if (split < 0 || !"jar".equalsIgnoreCase(ipath.substring(split + 1))) continue;
                    Utility.recursePathJars(ipath, paths);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String[] getClassPaths() {
        String path = System.getProperty("java.class.path");
        ArrayList<String> paths = new ArrayList<String>();
        int start = 0;
        while (path != null) {
            String item;
            int mark = path.indexOf(File.pathSeparatorChar, start);
            if (mark >= 0) {
                item = path.substring(start, mark);
            } else {
                item = path.substring(start);
                path = null;
            }
            if (!paths.contains(item)) {
                paths.add(item);
                int split = item.lastIndexOf(46);
                if (split >= 0 && "jar".equalsIgnoreCase(item.substring(split + 1))) {
                    Utility.recursePathJars(item, paths);
                }
            }
            start = mark + 1;
        }
        paths.add(".");
        String[] clsspths = new String[paths.size()];
        paths.toArray(clsspths);
        return clsspths;
    }

    public static String convertName(String name) {
        StringBuffer buff = new StringBuffer(name);
        if (!Character.isJavaIdentifierStart(buff.charAt(0))) {
            buff.insert(0, 'X');
        }
        for (int i = 1; i < buff.length(); ++i) {
            if (Character.isJavaIdentifierPart(buff.charAt(i))) continue;
            buff.setCharAt(i, '_');
        }
        return buff.toString();
    }

    public static String fileName(String path) {
        int split = path.lastIndexOf(File.separatorChar);
        return path.substring(split + 1);
    }

    public static BindingDefinition loadBinding(String fname, String sname, InputStream strm) throws JiBXException, IOException {
        UnmarshallingContext uctx = new UnmarshallingContext(0, new String[0], new String[0], new String[0], new String[0]);
        uctx.setDocument(strm, fname);
        return BindingBuilder.unmarshalBindingDefinition(uctx, sname);
    }

    public static BindingDefinition loadBinding(String fname, String sname, Reader rdr) throws JiBXException, IOException {
        UnmarshallingContext uctx = new UnmarshallingContext(0, new String[0], new String[0], new String[0], new String[0]);
        uctx.setDocument(rdr, fname);
        return BindingBuilder.unmarshalBindingDefinition(uctx, sname);
    }

    public static BindingDefinition loadFileBinding(String path) throws JiBXException, IOException {
        String fname = Utility.fileName(path);
        String sname = fname;
        int split = sname.indexOf(46);
        if (split > 0) {
            sname = sname.substring(0, split);
        }
        sname = Utility.convertName(sname);
        FileReader rdr = new FileReader(path);
        return Utility.loadBinding(fname, sname, rdr);
    }
}

