/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.runtime.JiBXException;

public class Loader
extends URLClassLoader {
    private ArrayList m_bindings = new ArrayList();
    private boolean m_isBound;
    private HashMap m_classMap = new HashMap();

    public Loader(URL[] paths, ClassLoader parent) {
        super(paths, parent);
        ArrayList<String> fpaths = new ArrayList<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            URL path = paths[i];
            if (!"file".equals(path.getProtocol())) continue;
            fpaths.add(path.getPath());
        }
        String[] dirs = fpaths.toArray(new String[0]);
        ClassCache.setPaths(dirs);
        ClassFile.setPaths(dirs);
        BoundClass.reset();
        MungedClass.reset();
        BindingDefinition.reset();
    }

    public Loader(URL[] paths) {
        this(paths, ClassLoader.getSystemClassLoader().getParent());
    }

    public Loader() throws MalformedURLException {
        this(Loader.getClassPaths());
    }

    public void reset() {
        this.m_bindings.clear();
        this.m_classMap.clear();
        this.m_isBound = false;
        BoundClass.reset();
        MungedClass.reset();
        BindingDefinition.reset();
    }

    public static URL[] getClassPaths() throws MalformedURLException {
        String[] paths = Utility.getClassPaths();
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new File(paths[i]).toURL();
        }
        return urls;
    }

    public void loadBinding(String fname, String sname, InputStream is) throws JiBXException, IOException {
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        this.m_bindings.add(Utility.loadBinding(fname, sname, is));
    }

    public void loadBinding(String fname, String sname, Reader rdr) throws JiBXException, IOException {
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        this.m_bindings.add(Utility.loadBinding(fname, sname, rdr));
    }

    public void loadFileBinding(String path) throws JiBXException, IOException {
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        this.m_bindings.add(Utility.loadFileBinding(path));
    }

    public void loadResourceBinding(String path) throws JiBXException, IOException {
        String sname;
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        String fname = path;
        int split = fname.lastIndexOf(47);
        if (split >= 0) {
            fname = fname.substring(split + 1);
        }
        if ((split = (sname = fname).lastIndexOf(46)) >= 0) {
            sname = sname.substring(0, split);
        }
        sname = Utility.convertName(sname);
        InputStream is = this.getResourceAsStream(path);
        if (is == null) {
            throw new IOException("Resource " + path + " not found");
        }
        InputStreamReader rdr = new InputStreamReader(is);
        this.loadBinding(fname, sname, rdr);
    }

    public void processBindings() throws JiBXException {
        if (!this.m_isBound) {
            int count = this.m_bindings.size();
            for (int i = 0; i < count; ++i) {
                BindingDefinition binding = (BindingDefinition)this.m_bindings.get(i);
                binding.generateCode();
            }
            ClassFile[][] lists = MungedClass.fixChanges(false);
            count = lists[0].length;
            for (int i = 0; i < count; ++i) {
                ClassFile clas = lists[0][i];
                this.m_classMap.put(clas.getName(), clas);
            }
            this.m_isBound = true;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        ClassFile clas;
        if (!this.m_isBound) {
            try {
                this.processBindings();
            }
            catch (JiBXException e) {
                e.printStackTrace();
            }
        }
        if ((clas = (ClassFile)this.m_classMap.get(name)) != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                clas.writeFile(bos);
                byte[] bytes = bos.toByteArray();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Unable to load modified class " + name);
            }
        }
        return super.findClass(name);
    }
}

