/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.wap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.kxml.io.XmlWriter;
import org.kxml.kdom.Document;
import org.kxml.parser.ParseEvent;
import org.kxml.wap.WbxmlParser;

public class WapExtensionEvent
extends ParseEvent {
    private int id;
    private Object content;

    public WapExtensionEvent(int id, Object content) {
        super(id, null);
        this.setContent(content);
    }

    @Override
    public int getType() {
        return 1024;
    }

    public int getId() {
        return this.id;
    }

    public Object getContent() {
        return this.content;
    }

    private void setContent(Object content) {
        if (content != null) {
            if (content instanceof byte[]) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream((byte[])content);
                    WbxmlParser parser = new WbxmlParser((InputStream)is, 2);
                    Document document = new Document();
                    document.parse(parser);
                    this.content = document;
                }
                catch (Exception ex) {
                    this.content = content;
                }
            } else {
                this.content = content;
            }
        }
    }

    @Override
    public String getText() {
        if (this.content != null) {
            if (this.content instanceof byte[]) {
                String stringRepresentation = null;
                try {
                    stringRepresentation = new String((byte[])this.content, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    stringRepresentation = new String((byte[])this.content);
                }
                return stringRepresentation;
            }
            if (this.content instanceof Document) {
                try {
                    StringWriter out = new StringWriter();
                    XmlWriter writer = new XmlWriter(out);
                    Document document = (Document)this.content;
                    document.write(writer);
                    ((Writer)writer).close();
                    return out.toString();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                return this.content.toString();
            }
        }
        return null;
    }
}

