/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.CostOps;
import org.vmguys.vmtools.utils.DifferenceFinder2;
import org.vmguys.vmtools.utils.ProgressReporter;

public class JdomDifferenceFinder {
    private DifferenceFinder2 differ;
    private Namespace namespace;

    public JdomDifferenceFinder() {
        this(Namespace.NO_NAMESPACE);
    }

    public JdomDifferenceFinder(Namespace namespace) {
        this(namespace, true);
    }

    public JdomDifferenceFinder(Namespace namespace, boolean discardWhitespace) {
        this(namespace, discardWhitespace, false);
    }

    public JdomDifferenceFinder(Namespace namespace, boolean discardWhitespace, boolean addComments) {
        this.namespace = namespace;
        this.differ = new DifferenceFinder2(namespace, discardWhitespace, addComments);
    }

    public void findDifferences(Element tree1, Element tree2, Element diffRoot) throws JDOMException {
        CostOps ops = this.differ.findDifferences(tree1, tree2);
        ops.sortOperations();
        AbstractOperation prevOp = null;
        Element currPos = null;
        int i = 0;
        while (i < ops.getOps().size()) {
            AbstractOperation currOp = (AbstractOperation)ops.getOps().get(i);
            if (prevOp != null && currOp.getOperationXpath().equals(prevOp.getOperationXpath())) {
                currPos.addContent(currOp.asElement(this.namespace));
            } else {
                currPos = new Element("Position", this.namespace);
                currPos.setAttribute("XPath", currOp.getOperationXpath());
                diffRoot.addContent(currPos);
                currPos.addContent(currOp.asElement(this.namespace));
            }
            prevOp = currOp;
            ++i;
        }
    }

    public void setProgressReporter(ProgressReporter pr) {
        if (this.differ != null) {
            this.differ.setProgressReporter(pr);
        }
    }

    public void setAllowRename(boolean flag) {
        this.differ.setAllowRename(flag);
    }
}

