/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.web.monitor;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RequestSample {
    private Map headers = null;
    private String url = null;
    private String sessionId = null;
    private long startTimestamp = -1L;
    private long endTimestamp = -1L;

    public RequestSample(HttpServletRequest request, long startTimestamp, long endTimestamp) {
        HttpSession session;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null!");
        }
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        String query = request.getQueryString();
        this.url = request.getMethod().toUpperCase() + " - " + request.getRequestURI();
        if (query != null) {
            this.url = this.url + '?' + query;
        }
        this.sessionId = (session = request.getSession(false)) == null ? "-" : session.getId();
        this.headers = new HashMap();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            this.headers.put(header, request.getHeader(header));
        }
    }

    public RequestSample(HttpServletRequest request, long startTimestamp) {
        this(request, startTimestamp, -1L);
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Date getEndDate() {
        return new Date(this.endTimestamp);
    }

    public Date getStartDate() {
        return new Date(this.startTimestamp);
    }

    public String getUrl() {
        return this.url;
    }

    public long getElapsedMilliseconds() {
        if (this.startTimestamp == -1L) {
            throw new IllegalArgumentException("startTimestamp not valid: " + this.startTimestamp);
        }
        if (this.endTimestamp == -1L) {
            throw new IllegalArgumentException("endTimestamp not valid: " + this.endTimestamp);
        }
        return this.endTimestamp - this.startTimestamp;
    }

    public int hashCode() {
        return (this.url + String.valueOf(this.startTimestamp)).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RequestSample) {
            return this.url.equals(((RequestSample)o).getUrl()) && this.startTimestamp == ((RequestSample)o).getStartTimestamp();
        }
        return false;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Map getHeaders() {
        return this.headers;
    }
}

