/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class SqueezeOutputStream
extends ServletOutputStream {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_SKIP = 1;
    private int state = 0;
    private OutputStream out = null;

    public SqueezeOutputStream(OutputStream out) {
        this.out = out;
        this.state = 0;
    }

    public void write(int b) throws IOException {
        switch (this.state) {
            case 0: {
                if (b != 10) break;
                this.out.write(b);
                this.state = 1;
                break;
            }
            case 1: {
                if (Character.isWhitespace((char)b)) break;
                this.state = 0;
            }
        }
        if (this.state == 0) {
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int i;
        int start = off;
        block4: for (i = off; i < b.length && i - off < len; ++i) {
            switch (this.state) {
                case 0: {
                    if (b[i] != 10) continue block4;
                    this.out.write(b, start, i - start + 1);
                    this.state = 1;
                    continue block4;
                }
                case 1: {
                    if (Character.isWhitespace((char)b[i])) continue block4;
                    this.state = 0;
                    start = i;
                }
            }
        }
        if (this.state == 0) {
            this.out.write(b, start, i - start);
        }
    }
}

