/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.nxt.comm.Bluetooth;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.NXTInputStream;
import lejos.nxt.comm.NXTOutputStream;

public class BTConnection
implements NXTConnection {
    static final int CS_IDLE = 0;
    static final int CS_DISCONNECTED = 1;
    static final int CS_CONNECTED = 2;
    static final int CS_DATALOST = 3;
    static final int CS_DISCONNECTING = 4;
    private static final int BTC_BUFSZ = 256;
    private static final int BTC_DEFHEADER = 2;
    private static final int BTC_CLOSETIMEOUT1 = 1000;
    private static final int BTC_CLOSETIMEOUT2 = 250;
    private static final int BTC_FLUSH_WAIT = 10;
    public static final int AM_DISABLE = 0;
    public static final int AM_ALWAYS = 1;
    public static final int AM_OUTPUT = 2;
    int state = 0;
    int chanNo;
    byte handle;
    int header = 2;
    int switchMode;
    byte[] inBuf;
    byte[] outBuf;
    int inCnt;
    int inOffset;
    int outCnt;
    int outOffset;
    int pktOffset;
    int pktLen;
    InputStream is;
    OutputStream os;
    static int inBufSz = 256;
    static int outBufSz = 256;
    byte[] bt_address;

    public BTConnection(int chan) {
        this.chanNo = chan;
        this.is = null;
        this.os = null;
    }

    public byte[] getAddress() {
        return this.bt_address;
    }

    synchronized void reset() {
        this.state = 0;
        this.inBuf = null;
        this.outBuf = null;
        this.notifyAll();
    }

    synchronized void bind(byte handle, byte[] address) {
        this.bt_address = address;
        this.bind(handle);
    }

    synchronized void bind(byte handle) {
        if (this.inBuf == null) {
            this.inBuf = new byte[inBufSz];
        }
        if (this.outBuf == null) {
            this.outBuf = new byte[outBufSz];
        }
        this.inCnt = 0;
        this.inOffset = 0;
        this.outCnt = 0;
        this.outOffset = 0;
        this.state = 2;
        this.header = 2;
        this.switchMode = 1;
        this.handle = handle;
        this.pktOffset = -this.header;
        this.pktLen = 0;
    }

    synchronized boolean disconnected() {
        this.notifyAll();
        if (this.state <= 1) {
            return false;
        }
        this.state = 1;
        this.outCnt = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.state == 0) {
            return;
        }
        BTConnection bTConnection = this;
        synchronized (bTConnection) {
            if (this.state >= 2) {
                this.state = 4;
            }
        }
        for (int i = 0; this.state == 4 && (i < 250 || this.outCnt > 0 && i < 1000); ++i) {
            this.read(null, this.inBuf.length, false);
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.outCnt = 0;
        if (this.state == 4) {
            Bluetooth.closeConnection(this.handle);
        }
        BTConnection bTConnection2 = this;
        synchronized (bTConnection2) {
            while (this.state == 4) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            this.state = 0;
            this.inBuf = null;
            this.outBuf = null;
        }
    }

    synchronized void send() {
        if (this.outOffset >= this.outCnt) {
            return;
        }
        int cnt = Bluetooth.btWrite(this.outBuf, this.outOffset, this.outCnt - this.outOffset);
        this.outOffset += cnt;
        if (this.outOffset >= this.outCnt) {
            this.outOffset = 0;
            this.outCnt = 0;
            this.notifyAll();
        }
    }

    public synchronized int write(byte[] data, int len, boolean wait) {
        int offset = -this.header;
        int hdr = len;
        if (this.state == 3) {
            this.state = 2;
            return -2;
        }
        if (this.state != 2) {
            return -1;
        }
        if (this.outCnt > 0 && !wait) {
            return 0;
        }
        while (offset < len) {
            while (this.outCnt >= this.outBuf.length) {
                if (!wait && this.header == 0) {
                    return offset;
                }
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.state == 2) continue;
                return offset;
            }
            if (offset < 0) {
                this.outBuf[this.outCnt++] = (byte)hdr;
                hdr >>= 8;
                ++offset;
                continue;
            }
            int cnt = this.outBuf.length - this.outCnt;
            if (cnt > len - offset) {
                cnt = len - offset;
            }
            System.arraycopy(data, offset, this.outBuf, this.outCnt, cnt);
            this.outCnt += cnt;
            offset += cnt;
        }
        return offset;
    }

    public int write(byte[] data, int len) {
        return this.write(data, len, true);
    }

    synchronized void recv() {
        while (this.inCnt < this.inBuf.length) {
            int len;
            int offset;
            int cnt;
            if (this.inCnt == 0) {
                this.inOffset = 0;
            }
            if ((cnt = Bluetooth.btRead(this.inBuf, offset, len = (offset = (this.inOffset + this.inCnt) % this.inBuf.length) >= this.inOffset ? this.inBuf.length - offset : this.inOffset - offset)) <= 0) break;
            this.inCnt += cnt;
        }
        if (this.inCnt > 0) {
            this.notifyAll();
        }
    }

    public synchronized int read(byte[] data, int outLen, boolean wait) {
        int offset = 0;
        if (this.header == 0) {
            this.pktOffset = 0;
            this.pktLen = outLen;
        }
        if (this.state == 0) {
            return -1;
        }
        if (this.state == 3) {
            this.state = 2;
            return -2;
        }
        if (this.state == 1 && this.inCnt <= 0) {
            return -1;
        }
        if (!wait && this.inCnt <= 0) {
            return 0;
        }
        while (this.pktOffset < this.pktLen) {
            while (this.inCnt <= 0) {
                if (!wait) {
                    return offset;
                }
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.state == 2) continue;
                return offset;
            }
            if (this.pktOffset < 0) {
                this.pktLen += (this.inBuf[this.inOffset++] & 0xFF) << (this.header + this.pktOffset) * 8;
                ++this.pktOffset;
                --this.inCnt;
            } else {
                int len;
                if (offset >= outLen) {
                    return offset;
                }
                int n = len = this.inOffset + this.inCnt > this.inBuf.length ? this.inBuf.length - this.inOffset : this.inCnt;
                if (len > outLen - offset) {
                    len = outLen - offset;
                }
                if (len > this.pktLen - this.pktOffset) {
                    len = this.pktLen - this.pktOffset;
                }
                if (data != null) {
                    System.arraycopy(this.inBuf, this.inOffset, data, offset, len);
                }
                offset += len;
                this.inOffset += len;
                this.pktOffset += len;
                this.inCnt -= len;
                if (this.header == 0) {
                    wait = false;
                }
            }
            this.inOffset %= this.inBuf.length;
        }
        this.pktOffset = -this.header;
        this.pktLen = 0;
        return offset;
    }

    public int read(byte[] data, int len) {
        return this.read(data, len, true);
    }

    public synchronized int available(int what) {
        if (this.state == 0) {
            return -1;
        }
        if (this.state == 3) {
            this.state = 2;
            return -2;
        }
        if (this.header > 0) {
            if (this.pktOffset < 0) {
                this.read(null, 0, false);
            }
            if (this.pktOffset < 0) {
                return 0;
            }
            if (what == 2) {
                return this.pktLen;
            }
            int ret = this.pktLen - this.pktOffset;
            if (what == 0 && ret > this.inCnt) {
                ret = this.inCnt;
            }
            return ret;
        }
        return this.inCnt;
    }

    public int available() {
        return this.available(0);
    }

    public void setIOMode(int mode) {
        this.header = mode;
    }

    public int readPacket(byte[] buf, int len) {
        int pkt = this.available(1);
        if (pkt == -2) {
            return -2;
        }
        if (pkt < 255 && this.available(0) < pkt) {
            return 0;
        }
        return this.read(buf, len, false);
    }

    public void sendPacket(byte[] buf, int bufLen) {
        if (bufLen <= 254) {
            this.write(buf, bufLen, false);
        }
    }

    synchronized boolean needsAttention() {
        if (this.state < 2 || this.switchMode == 0) {
            return false;
        }
        if (this.outOffset < this.outCnt) {
            return true;
        }
        if (this.switchMode == 2) {
            return false;
        }
        return this.inCnt <= 0;
    }

    public void setActiveMode(int mode) {
        this.switchMode = mode;
    }

    public static void setInputBufferSize(int sz) {
        inBufSz = sz >= 0 ? sz : 256;
    }

    public static void setOutputBufferSize(int sz) {
        outBufSz = sz >= 0 ? sz : 256;
    }

    private boolean pendingInput() {
        return (Bluetooth.btPending() & 1) != 0;
    }

    synchronized void flushInput() {
        if (this.state == 0) {
            return;
        }
        int timeout = (int)System.currentTimeMillis() + 10;
        while (timeout > (int)System.currentTimeMillis()) {
            while (this.pendingInput() && this.inCnt < this.inBuf.length) {
                this.recv();
            }
            try {
                this.wait(1L);
            }
            catch (Exception exception) {}
        }
        if (!this.pendingInput()) {
            return;
        }
        timeout = (int)System.currentTimeMillis() + 10;
        while (this.pendingInput() || timeout > (int)System.currentTimeMillis()) {
            while (this.read(null, this.inBuf.length, false) > 0) {
            }
            this.recv();
        }
        if (this.state == 2) {
            this.state = 3;
        }
    }

    public InputStream openInputStream() {
        return this.is != null ? this.is : new NXTInputStream(this, 256);
    }

    public OutputStream openOutputStream() {
        return this.os != null ? this.os : new NXTOutputStream(this, 254);
    }

    public DataInputStream openDataInputStream() {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() {
        return new DataOutputStream(this.openOutputStream());
    }

    public void closeStream() {
    }

    public void openStream() {
    }

    public int getSignalStrength() {
        int strength = Bluetooth.getSignalStrength(this.handle);
        return strength;
    }
}

