/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.Button;
import lejos.nxt.LCD;

public class TextMenu {
    private int _topIndex = 0;
    private int _selectedIndex = 0;
    private int _size = 8;
    private int _topRow = 0;
    private String[] _items;
    private String _selChar = ">";
    public static String blank = "                ";
    private String _title;
    private boolean _quit = false;
    private int _length;
    private int _startTime;

    public TextMenu(String[] items) {
        this.setItems(items);
    }

    public TextMenu(String[] items, int topRow) {
        this._topRow = topRow;
        this.setItems(items);
    }

    public TextMenu(String[] items, int topRow, String title) {
        this._topRow = topRow;
        this.setTitle(title);
        this.setItems(items);
    }

    public void setTitle(String title) {
        this._title = title;
        if (this._topRow == 0) {
            this._topRow = 1;
        }
        if (this._length <= 8) {
            this._size = this._length;
        }
        if (this._size > 8 - this._topRow) {
            this._size = 8 - this._topRow;
        }
    }

    public void setItems(String[] items) {
        int i;
        this._items = items;
        if (items == null) {
            return;
        }
        for (i = 0; i < items.length && items[i] != null; ++i) {
        }
        this._size = this._length = i;
        if (this._size > 8 - this._topRow) {
            this._size = 8 - this._topRow;
        }
        this._quit = false;
        this._topIndex = 0;
    }

    public int select() {
        return this.select(0, 0);
    }

    public int select(int selectedIndex) {
        return this.select(selectedIndex, 0);
    }

    public int select(int selectedIndex, int timeout) {
        this._selectedIndex = selectedIndex;
        int button = 0;
        this._quit = false;
        this.resetTimeout();
        this.display();
        while (!this._quit) {
            while (Button.readButtons() > 0 && !this._quit) {
                Thread.yield();
            }
            while (Button.readButtons() == 0 && !this._quit) {
                if (timeout > 0 && (int)System.currentTimeMillis() - this._startTime >= timeout) {
                    return -3;
                }
                Thread.yield();
            }
            if (this._quit) {
                return -2;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            button = Button.readButtons();
            if (button == 1) {
                return this._selectedIndex;
            }
            if (button == 8) {
                return -1;
            }
            if (button == 4) {
                int diff;
                ++this._selectedIndex;
                if (this._selectedIndex >= this._length) {
                    this._selectedIndex -= this._length;
                }
                if ((diff = this._selectedIndex - this._topIndex) < 0) {
                    diff += this._length;
                }
                if (diff >= this._size) {
                    this._topIndex = 1 + this._selectedIndex - this._size;
                }
            }
            if (button == 2) {
                int diff;
                --this._selectedIndex;
                if (this._selectedIndex < 0) {
                    this._selectedIndex += this._length;
                }
                if ((diff = this._selectedIndex - this._topIndex) > this._length) {
                    diff -= this._length;
                }
                if (diff < 0 || diff >= this._size) {
                    this._topIndex = this._selectedIndex;
                }
            }
            this.display();
        }
        return -2;
    }

    public void quit() {
        this._quit = true;
    }

    private void display() {
        int i;
        if (this._title != null) {
            LCD.drawString(this._title, 0, this._topRow - 1);
        }
        for (i = 0; i < this._size; ++i) {
            LCD.drawString(blank, 0, i + this._topRow);
            int indx = this.index(i);
            if (this._items[indx] != null) {
                LCD.drawString(this._items[indx], 1, i + this._topRow);
                if (indx != this._selectedIndex) continue;
                LCD.drawString(this._selChar, 0, i + this._topRow);
                continue;
            }
            LCD.drawString(blank, 0, i + this._topRow);
        }
        for (i = this._size + this._topRow; i < 8; ++i) {
            LCD.drawString(blank, 0, i);
        }
        LCD.refresh();
    }

    private int index(int row) {
        return (this._topIndex + row + this._length) % this._length;
    }

    public String[] getItems() {
        return this._items;
    }

    public void resetTimeout() {
        this._startTime = (int)System.currentTimeMillis();
    }
}

