/*
 * Decompiled with CFR 0.152.
 */
package lejos.navigation;

import lejos.nxt.Motor;

public class Pilot {
    protected Motor _left;
    protected Motor _right;
    public final float _degPerDistance;
    private final float _turnRatio;
    protected int _speed = 360;
    private byte _parity = 1;
    private boolean _regulating = true;
    public final float _trackWidth;
    public final float _wheelDiameter;

    public Pilot(float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor) {
        this._left = leftMotor;
        this._right = rightMotor;
        this._degPerDistance = 360.0f / ((float)Math.PI * wheelDiameter);
        this._turnRatio = trackWidth / wheelDiameter;
        this._trackWidth = trackWidth;
        this._wheelDiameter = wheelDiameter;
    }

    public Pilot(float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        this(wheelDiameter, trackWidth, leftMotor, rightMotor);
        this._parity = reverse ? (byte)-1 : (byte)1;
    }

    public Motor getLeft() {
        return this._left;
    }

    public Motor getRight() {
        return this._right;
    }

    public int getLeftCount() {
        return this._parity * this._left.getTachoCount();
    }

    public int getRightCount() {
        return this._parity * this._right.getTachoCount();
    }

    public int getLeftActualSpeed() {
        return this._left.getActualSpeed();
    }

    public int getRightActualSpeed() {
        return this._right.getActualSpeed();
    }

    public float getTurnRatio() {
        return this._turnRatio;
    }

    public int getSpeed() {
        return this._speed;
    }

    public void setSpeed(int speed) {
        this._speed = speed;
        this._left.regulateSpeed(this._regulating);
        this._left.smoothAcceleration(!this.isMoving());
        this._right.regulateSpeed(this._regulating);
        this._right.smoothAcceleration(!this.isMoving());
        if (this._left.getSpeed() != speed) {
            this._left.setSpeed(speed);
        }
        if (this._right.getSpeed() != speed) {
            this._right.setSpeed(speed);
        }
    }

    public void forward() {
        this.setSpeed(this._speed);
        if (this._parity == 1) {
            this.fwd();
        } else {
            this.bak();
        }
    }

    public void backward() {
        this.setSpeed(this._speed);
        if (this._parity == 1) {
            this.bak();
        } else {
            this.fwd();
        }
    }

    public void rotate(int angle) {
        this.rotate(angle, false);
    }

    public void rotate(int angle, boolean immediateReturn) {
        this.setSpeed(this._speed);
        int ta = this._parity * (int)((float)angle * this._turnRatio);
        this._left.rotate(-ta, true);
        this._right.rotate(ta, true);
        if (immediateReturn) {
            return;
        }
        while (this.isMoving()) {
            Thread.yield();
        }
    }

    public int getAngle() {
        return this._parity * Math.round((float)(this.getRightCount() - this.getLeftCount()) / (2.0f * this._turnRatio));
    }

    public void stop() {
        this._left.stop();
        this._right.stop();
    }

    public boolean isMoving() {
        return this._left.isMoving() || this._right.isMoving() || this._left.isRotating() || this._right.isRotating();
    }

    public void resetTachoCount() {
        this._left.resetTachoCount();
        this._right.resetTachoCount();
    }

    public float getTravelDistance() {
        int avg = (this._left.getTachoCount() + this._right.getTachoCount()) / 2;
        return (float)(this._parity * avg) / this._degPerDistance;
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void travel(float distance, boolean immediateReturn) {
        this.setSpeed(this._speed);
        this._left.rotate((int)((float)this._parity * distance * this._degPerDistance), true);
        this._right.rotate((int)((float)this._parity * distance * this._degPerDistance), true);
        if (immediateReturn) {
            return;
        }
        while (this.isMoving()) {
            Thread.yield();
        }
    }

    public void steer(int turnRate) {
        this.steer(turnRate, Integer.MAX_VALUE, true);
    }

    public void steer(int turnRate, int angle) {
        this.steer(turnRate, angle, false);
    }

    public void steer(int turnRate, int angle, boolean immediateReturn) {
        Motor outside;
        Motor inside;
        int rate = turnRate;
        if (rate < -200) {
            rate = -200;
        }
        if (rate > 200) {
            rate = 200;
        }
        if (rate == 0) {
            if (angle < 0) {
                this.backward();
            } else {
                this.forward();
            }
            return;
        }
        if (turnRate < 0) {
            inside = this._right;
            outside = this._left;
            rate = -rate;
        } else {
            inside = this._left;
            outside = this._right;
        }
        outside.setSpeed(this._speed);
        float steerRatio = 1.0f - (float)rate / 100.0f;
        inside.setSpeed((int)((float)this._speed * steerRatio));
        if (angle == Integer.MAX_VALUE) {
            if (this._parity == 1) {
                outside.forward();
            } else {
                outside.backward();
            }
            if ((float)this._parity * steerRatio > 0.0f) {
                inside.forward();
            } else {
                inside.backward();
            }
            return;
        }
        float rotAngle = (float)angle * this._trackWidth * 2.0f / (this._wheelDiameter * (1.0f - steerRatio));
        inside.rotate(this._parity * (int)(rotAngle * steerRatio), true);
        outside.rotate(this._parity * (int)rotAngle, true);
        if (immediateReturn) {
            return;
        }
        while (this.isMoving()) {
            Thread.yield();
        }
        inside.setSpeed(outside.getSpeed());
    }

    private void bak() {
        this._left.backward();
        this._right.backward();
    }

    public void regulateSpeed(boolean yes) {
        this._regulating = yes;
        this._left.regulateSpeed(yes);
        this._right.regulateSpeed(yes);
    }

    private void fwd() {
        this._left.forward();
        this._right.forward();
    }
}

