/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class Gauge
extends Item {
    private int maxValue;
    private int curValue;

    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        this.label = label;
        this.interactive = interactive;
        this.maxValue = maxValue;
        this.curValue = initialValue;
        if (label != null) {
            this.minWidth = label.length() * 6 + 2 * maxValue;
            this.minHeight = this.minWidth < 100 && maxValue <= 8 ? 8 : 8 + maxValue;
        } else {
            this.minWidth = 2 * maxValue;
            this.minHeight = maxValue;
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getValue() {
        return this.curValue;
    }

    public void setValue(int value) {
        this.curValue = value;
        if (this.curValue < 0) {
            this.curValue = 0;
        } else if (this.curValue > this.maxValue) {
            this.curValue = this.maxValue;
        }
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 39) {
            if (this.interactive && this.curValue < this.maxValue) {
                ++this.curValue;
            }
            this.repaint();
        } else if (keyCode == 37) {
            if (this.interactive && this.curValue > 0) {
                --this.curValue;
            }
            this.repaint();
        } else if (keyCode == 40 || keyCode == 38) {
            this.notifyStateChanged();
        }
    }

    public void paint(Graphics g, int x, int y, int w, int h, boolean selected) {
        int barWidth = w / this.maxValue;
        int barIncr = h / this.maxValue;
        int barOffset = 0;
        if (this.label != null) {
            g.drawString(this.label, x, y, selected);
            if (h > 8) {
                barIncr = (h - 8) / this.maxValue;
            } else {
                barOffset = this.label.length() * 6;
                barWidth = (w - barOffset) / this.maxValue;
            }
        }
        for (int i = 0; i < this.curValue; ++i) {
            int barHeight = (i + 1) * barIncr;
            g.fillRect(barOffset + i * barWidth, y + h - barHeight, barWidth >> 1, barHeight);
        }
    }
}

