/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.ibm.oti.vm.VM;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public abstract class NativeLibLoader {
    static final int OS_UNSUPPORTED = -1;
    static final int OS_LINUX = 1;
    static final int OS_WINDOWS = 2;
    static final int OS_WINDOWS_CE = 3;
    static final int OS_MAC_OS_X = 4;
    private static int os = 0;
    private static Hashtable libsState = new Hashtable();
    private static String bluecoveDllDir = null;
    static /* synthetic */ Class class$com$intel$bluetooth$NativeLibLoader;

    private NativeLibLoader() {
    }

    static int getOS() {
        if (os != 0) {
            return os;
        }
        String sysName = System.getProperty("os.name");
        if (sysName == null) {
            DebugLog.fatal("Native Library not available on unknown platform");
            os = -1;
        } else if ((sysName = sysName.toLowerCase()).indexOf("windows") != -1) {
            os = sysName.indexOf("ce") != -1 ? 3 : 2;
        } else if (sysName.indexOf("mac os x") != -1) {
            os = 4;
        } else if (sysName.indexOf("linux") != -1) {
            os = 1;
        } else {
            DebugLog.fatal("Native Library not available on platform " + sysName);
            os = -1;
        }
        return os;
    }

    static boolean isAvailable(String name) {
        String libName;
        LibState state = (LibState)libsState.get(name);
        if (state == null) {
            state = new LibState();
            libsState.put(name, state);
        }
        if (state.triedToLoadAlredy) {
            return state.libraryAvailable;
        }
        String libFileName = libName = name;
        String sysName = System.getProperty("os.name");
        switch (NativeLibLoader.getOS()) {
            case -1: {
                DebugLog.fatal("Native Library " + name + " not available on [" + sysName + "] platform");
                state.triedToLoadAlredy = true;
                state.libraryAvailable = false;
                return state.libraryAvailable;
            }
            case 3: {
                libFileName = libName = libName + "_ce";
                libFileName = libFileName + ".dll";
                break;
            }
            case 2: {
                libFileName = libFileName + ".dll";
                break;
            }
            case 4: {
                libFileName = "lib" + libFileName + ".jnilib";
                break;
            }
            case 1: {
                libFileName = "lib" + libFileName + ".so";
                break;
            }
            default: {
                DebugLog.fatal("Native Library " + name + " not available on platform " + sysName);
                state.triedToLoadAlredy = true;
                state.libraryAvailable = false;
                return state.libraryAvailable;
            }
        }
        String path = System.getProperty("bluecove.native.path");
        if (path != null && !UtilsJavaSE.ibmJ9midp) {
            state.libraryAvailable = NativeLibLoader.tryloadPath(path, libFileName);
        }
        boolean useResource = true;
        String d = System.getProperty("bluecove.native.resource");
        if (d != null && d.equalsIgnoreCase("false")) {
            useResource = false;
        }
        if (!state.libraryAvailable && useResource && !UtilsJavaSE.ibmJ9midp) {
            state.libraryAvailable = NativeLibLoader.loadAsSystemResource(libFileName);
        }
        if (!state.libraryAvailable) {
            state.libraryAvailable = !UtilsJavaSE.ibmJ9midp ? NativeLibLoader.tryload(libName) : NativeLibLoader.tryloadIBMj9MIDP(libName);
        }
        if (!state.libraryAvailable) {
            System.err.println("Native Library " + libName + " not available");
            DebugLog.debug("java.library.path", System.getProperty("java.library.path"));
        }
        state.triedToLoadAlredy = true;
        return state.libraryAvailable;
    }

    private static boolean tryload(String name) {
        try {
            System.loadLibrary(name);
            DebugLog.debug("Library loaded", name);
        }
        catch (Throwable e) {
            DebugLog.error("Library " + name + " not loaded ", e);
            return false;
        }
        return true;
    }

    private static boolean tryloadIBMj9MIDP(String name) {
        try {
            VM.loadLibrary((String)name);
            DebugLog.debug("Library loaded", name);
        }
        catch (Throwable e) {
            DebugLog.error("Library " + name + " not loaded ", e);
            return false;
        }
        return true;
    }

    private static boolean tryloadPath(String path, String name) {
        try {
            File f = new File(path, name);
            if (!f.canRead()) {
                DebugLog.fatal("Native Library " + f.getAbsolutePath() + " not found");
                return false;
            }
            System.load(f.getAbsolutePath());
            DebugLog.debug("Library loaded", f.getAbsolutePath());
        }
        catch (Throwable e) {
            DebugLog.error("Can't load library from path " + path, e);
            return false;
        }
        return true;
    }

    private static boolean tryloadPathIBMj9MIDP(String path, String name) {
        try {
            VM.loadLibrary((String)(path + "\\" + name));
            DebugLog.debug("Library loaded", path + "\\" + name);
        }
        catch (Throwable e) {
            DebugLog.error("Can't load library from path " + path + "\\" + name, e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadAsSystemResource(String libFileName) {
        InputStream is = null;
        try {
            ClassLoader clo = null;
            try {
                clo = (class$com$intel$bluetooth$NativeLibLoader == null ? (class$com$intel$bluetooth$NativeLibLoader = NativeLibLoader.class$("com.intel.bluetooth.NativeLibLoader")) : class$com$intel$bluetooth$NativeLibLoader).getClassLoader();
            }
            catch (Throwable j9) {
                // empty catch block
            }
            is = clo == null ? ClassLoader.getSystemResourceAsStream(libFileName) : clo.getResourceAsStream(libFileName);
        }
        catch (Throwable e) {
            DebugLog.error("Native Library " + libFileName + " is not a Resource !");
            return false;
        }
        if (is == null) {
            DebugLog.error("Native Library " + libFileName + " is not a Resource !");
            return false;
        }
        File fd = NativeLibLoader.makeTempName(libFileName);
        try {
            if (!NativeLibLoader.copy2File(is, fd)) {
                boolean j9 = false;
                return j9;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {
                is = null;
            }
        }
        try {
            fd.deleteOnExit();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            System.load(fd.getAbsolutePath());
            DebugLog.debug("Library loaded from", fd);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy2File(InputStream is, File fd) {
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(fd);
            byte[] b = new byte[1000];
            while ((len = is.read(b)) >= 0) {
                fos.write(b, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            DebugLog.debug("Can't create temporary file ", e);
            System.err.println("Can't create temporary file " + fd.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {
                    fos = null;
                }
            }
        }
    }

    private static File makeTempName(String libFileName) {
        if (bluecoveDllDir != null) {
            return new File(bluecoveDllDir, libFileName);
        }
        String tmpDir = System.getProperty("java.io.tmpdir");
        String uname = System.getProperty("user.name");
        int count = 0;
        File fd = null;
        File dir = null;
        block7: while (true) {
            if (count > 10) {
                DebugLog.debug("Can't create temporary dir " + dir.getAbsolutePath());
                return new File(tmpDir, libFileName);
            }
            dir = new File(tmpDir, "bluecove_" + uname + "_" + count++);
            if (dir.exists()) {
                if (!dir.isDirectory()) continue;
                try {
                    File[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].delete()) continue block7;
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (!dir.exists() && !dir.mkdirs()) {
                DebugLog.debug("Can't create temporary dir ", dir.getAbsolutePath());
                continue;
            }
            try {
                dir.deleteOnExit();
            }
            catch (Throwable e) {
                // empty catch block
            }
            fd = new File(dir, libFileName);
            if (fd.exists() && !fd.delete()) continue;
            try {
                if (fd.createNewFile()) break;
                DebugLog.debug("Can't create file in temporary dir ", fd.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                DebugLog.debug("Can't create file in temporary dir ", fd.getAbsolutePath());
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
            break;
        }
        bluecoveDllDir = dir.getAbsolutePath();
        return fd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LibState {
        boolean triedToLoadAlredy = false;
        boolean libraryAvailable = false;

        private LibState() {
        }
    }
}

