/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;

public abstract class WritableDataWithOffset
implements WritableData {
    private int _offset = -1;

    public void initOffset(int startOffset) throws TinyVMException {
        assert (startOffset != -1) : "Precondition: aStart != -1";
        if (startOffset < 0 || startOffset > 65535) {
            throw new TinyVMException("Offset out of range (" + startOffset + ")");
        }
        this._offset = startOffset;
    }

    public int getOffset() throws TinyVMException {
        assert (this._offset != -1) : "Precondition: _offset != -1";
        if (this._offset <= 0 || this._offset > 65535) {
            throw new TinyVMException("Offset out of range (" + this._offset + ")");
        }
        assert (this._offset >= 0 && this._offset <= 65535) : "Postcondition: result >=0 && result <= 0xFFFF";
        return this._offset;
    }
}

