/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommInputStream;
import lejos.pc.comm.NXTCommOutputStream;
import lejos.pc.comm.NXTInfo;

public class NXTCommLibnxt
implements NXTComm {
    private NXTInfo nxtInfo;

    public native long jlibnxt_find(int var1);

    public native int jlibnxt_open(long var1);

    public native void jlibnxt_close(long var1);

    public native void jlibnxt_send_data(long var1, byte[] var3) throws IOException;

    public native byte[] jlibnxt_read_data(long var1, int var3) throws IOException;

    public native String jlibnxt_serial(long var1);

    public native String jlibnxt_name(long var1);

    public NXTInfo[] search(String name, int protocol) {
        long nxt;
        if ((protocol & 1) == 0) {
            return new NXTInfo[0];
        }
        Vector<NXTInfo> nxtInfos = new Vector<NXTInfo>();
        int idx = 0;
        while ((nxt = this.jlibnxt_find(idx)) != 0L) {
            String nam = this.jlibnxt_name(nxt);
            if (nam == null) {
                nam = "Unknown";
            }
            if (name == null || name.equals(nam)) {
                String addr = this.jlibnxt_serial(nxt);
                if (addr == null) {
                    addr = "";
                }
                NXTInfo info = new NXTInfo();
                info.name = nam;
                info.btDeviceAddress = addr;
                info.protocol = 1;
                info.nxtPtr = nxt;
                nxtInfos.add(info);
                System.out.println("Found nxt name " + nam + " address " + addr);
            }
            ++idx;
        }
        NXTInfo[] nxts = new NXTInfo[nxtInfos.size()];
        for (int i = 0; i < nxts.length; ++i) {
            nxts[i] = (NXTInfo)nxtInfos.elementAt(i);
        }
        return nxts;
    }

    public boolean open(NXTInfo nxtInfo) {
        if (nxtInfo.nxtPtr == 0L) {
            NXTInfo[] devs = this.search(nxtInfo.name, 1);
            if (devs.length == 0) {
                return false;
            }
            if (nxtInfo.btDeviceAddress.length() > 0) {
                for (int i = 0; i < devs.length; ++i) {
                    if (!nxtInfo.btDeviceAddress.equals(devs[i].btDeviceAddress)) continue;
                    this.nxtInfo = devs[i];
                    break;
                }
            } else {
                this.nxtInfo = devs[0];
            }
        } else {
            this.nxtInfo = nxtInfo;
        }
        int open = this.jlibnxt_open(nxtInfo.nxtPtr);
        return open == 0;
    }

    public void close() throws IOException {
        if (this.nxtInfo != null && this.nxtInfo.nxtPtr != 0L) {
            this.jlibnxt_close(this.nxtInfo.nxtPtr);
            this.nxtInfo.nxtPtr = 0L;
        }
    }

    public byte[] sendRequest(byte[] data, int replyLen) throws IOException {
        this.jlibnxt_send_data(this.nxtInfo.nxtPtr, data);
        if (replyLen == 0) {
            return new byte[0];
        }
        return this.jlibnxt_read_data(this.nxtInfo.nxtPtr, replyLen);
    }

    public byte[] read() throws IOException {
        byte[] ret = this.jlibnxt_read_data(this.nxtInfo.nxtPtr, 64);
        if (ret != null && ret.length == 0) {
            return null;
        }
        return ret;
    }

    public int available() throws IOException {
        return 0;
    }

    public void write(byte[] data) throws IOException {
        this.jlibnxt_send_data(this.nxtInfo.nxtPtr, data);
    }

    public OutputStream getOutputStream() {
        return new NXTCommOutputStream(this);
    }

    public InputStream getInputStream() {
        return new NXTCommInputStream(this);
    }

    static {
        System.loadLibrary("jlibnxt");
    }
}

