/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lejos.nxt.comm.BTConnection;
import lejos.nxt.comm.NXTSocket;
import lejos.nxt.comm.USBConnection;

public class NXTServerSocket {
    private int port;
    private BTConnection btc;
    private USBConnection usbc;
    private boolean isBluetooth;
    private final boolean isServer = true;

    public NXTServerSocket(int port, BTConnection btc) throws IOException {
        this.port = port;
        this.btc = btc;
        this.isBluetooth = true;
        this.negotiateConnection();
    }

    public NXTServerSocket(int port, USBConnection usbc) throws IOException {
        this.port = port;
        this.usbc = usbc;
        this.isBluetooth = false;
        this.negotiateConnection();
    }

    private void negotiateConnection() throws IOException {
        DataOutputStream dos = this.openDataOutputStream();
        dos.writeBoolean(true);
        dos.writeInt(this.port);
        dos.flush();
        dos.close();
    }

    private DataOutputStream openDataOutputStream() throws IOException {
        DataOutputStream dos = this.isBluetooth ? new DataOutputStream(this.btc.openOutputStream()) : new DataOutputStream(this.usbc.openOutputStream());
        return dos;
    }

    private DataInputStream openDataInputStream() throws IOException {
        DataInputStream dis = this.isBluetooth ? new DataInputStream(this.btc.openInputStream()) : new DataInputStream(this.usbc.openInputStream());
        return dis;
    }

    public NXTSocket accept() throws IOException {
        DataOutputStream dos = this.openDataOutputStream();
        DataInputStream dis = this.openDataInputStream();
        dos.writeByte(1);
        dos.flush();
        dis.readBoolean();
        dos.close();
        dis.close();
        if (this.isBluetooth) {
            return new NXTSocket(this.btc);
        }
        return new NXTSocket(this.usbc);
    }
}

