/*
 * Decompiled with CFR 0.152.
 */
package lejos.devices;

import java.util.Vector;

public class NMEASentence {
    private String sentence;
    private String prefix;
    private String dataType;
    private byte checksum;
    private Vector fields = null;
    private String COMMA = ",";
    private String BLANK = "";

    public NMEASentence(String sentence) {
        this.setSentence(sentence);
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
        this.refreshVals();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Vector getDataFields() {
        return this.fields;
    }

    public boolean isValid() {
        return this.getChecksum() == this.calcChecksum();
    }

    public byte getChecksum() {
        return this.checksum;
    }

    public byte calcChecksum() {
        int start = this.sentence.indexOf(36);
        int end = this.sentence.indexOf(42);
        if (end < 0) {
            end = this.sentence.length();
        }
        byte checksum = (byte)this.sentence.charAt(start + 1);
        for (int index = start + 2; index < end; ++index) {
            checksum = (byte)(checksum ^ (byte)this.sentence.charAt(index));
        }
        return checksum;
    }

    private void refreshVals() {
        this.prefix = this.sentence.substring(1, 3);
        this.dataType = this.sentence.substring(3, 6);
        int end = this.sentence.indexOf(42);
        String checksumStr = this.sentence.substring(end + 1, end + 3);
        this.fields = this.extractDataFields();
        this.checksum = NMEASentence.convertChecksum(checksumStr);
    }

    private Vector extractDataFields() {
        Vector df = new Vector(15);
        int end = this.sentence.indexOf(42);
        int firstIndex = this.sentence.indexOf(44);
        int nextIndex = 0;
        do {
            if ((nextIndex = this.sentence.indexOf(44, firstIndex + 1)) == -1) {
                nextIndex = end;
            }
            String dataField = null;
            dataField = this.sentence.substring(firstIndex + 1) == this.COMMA ? this.BLANK : this.sentence.substring(firstIndex + 1, nextIndex);
            df.addElement(dataField);
            firstIndex = nextIndex;
        } while (nextIndex != end);
        return df;
    }

    private static byte convertChecksum(String checksum_string) {
        byte checksum = (byte)((NMEASentence.hexCharToByte(checksum_string.charAt(0)) & 0xF) << 4);
        checksum = (byte)(checksum | NMEASentence.hexCharToByte(checksum_string.charAt(1)) & 0xF);
        return checksum;
    }

    private static byte hexCharToByte(char hex_char) {
        if (hex_char > '9') {
            return (byte)(hex_char - 55);
        }
        return (byte)(hex_char - 48);
    }
}

