/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class String {
    char[] characters;
    private int hash = 0;

    public String(char[] c, int off, int len) {
        this.characters = new char[len];
        System.arraycopy(c, off, this.characters, 0, len);
    }

    public String(char[] c) {
        this(c, 0, c.length);
    }

    public int length() {
        return this.characters.length;
    }

    public char charAt(int index) {
        return this.characters[index];
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int offset = 0;
        int max = offset + this.characters.length;
        char[] v = this.characters;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.characters.length) {
            return -1;
        }
        for (int i = offset + fromIndex; i < max; ++i) {
            if (v[i] != ch) continue;
            return i - offset;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public synchronized int indexOf(String str, int fromIndex) {
        return String.indexOf(this.characters, 0, this.characters.length, str.toCharArray(), 0, str.length(), fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.characters.length);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.characters, 0, this.characters.length, str.characters, 0, str.length(), fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public char[] toCharArray() {
        int len = this.characters.length;
        char[] ca = new char[len];
        System.arraycopy(this.characters, 0, ca, 0, len);
        return ca;
    }

    public synchronized String substring(int start) {
        return this.substring(start, this.characters.length);
    }

    public synchronized String substring(int start, int end) {
        if (start < 0 || end > this.characters.length || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.characters, start, end - start);
    }

    public static String valueOf(Object aObj) {
        return aObj == null ? "null" : aObj.toString();
    }

    public String toString() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        try {
            String os = (String)other;
            if (os.characters.length != this.characters.length) {
                return false;
            }
            for (int i = 0; i < this.characters.length; ++i) {
                if (this.characters[i] == os.characters[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int i = 0; i < this.characters.length; ++i) {
                h = 31 * h + this.characters[i];
            }
            this.hash = h;
        }
        return h;
    }
}

