/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import lejos.pc.comm.NXTInfo;

public class NXTTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Name", "Protocol", "Address"};
    private static final int NUM_COLUMNS = 3;
    Object[][] nxtData;
    int numNXTs;
    JFrame frame;

    public NXTTableModel(JFrame frame, NXTInfo[] nxts, int numNXTs) {
        this.frame = frame;
        this.setData(nxts, numNXTs);
    }

    public void setData(NXTInfo[] nxts, int numNXTs) {
        this.numNXTs = numNXTs;
        this.nxtData = new Object[numNXTs][3];
        for (int i = 0; i < numNXTs; ++i) {
            this.nxtData[i][0] = nxts[i].name;
            this.nxtData[i][1] = nxts[i].protocol == 1 ? "USB" : "Bluetooth";
            this.nxtData[i][2] = nxts[i].btDeviceAddress == null ? "" : nxts[i].btDeviceAddress;
        }
    }

    public int getRowCount() {
        return this.numNXTs;
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int column) {
        return this.nxtData[row][column];
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.nxtData[0][column].getClass();
    }
}

