/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;
import org.apache.bcel.classfile.Field;

public class StaticValue
extends WritableDataWithOffset {
    Field _field;
    TinyVMType iType;

    public StaticValue(Field aEntry) throws TinyVMException {
        this._field = aEntry;
        this.iType = TinyVMType.tinyVMType(this._field.getType());
    }

    public int getLength() throws TinyVMException {
        return this.iType.size();
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        try {
            switch (this.iType.type()) {
                case 4: {
                    writer.writeBoolean(false);
                    break;
                }
                case 8: {
                    writer.writeByte(0);
                    break;
                }
                case 5: {
                    writer.writeChar(0);
                    break;
                }
                case 9: {
                    writer.writeShort(0);
                    break;
                }
                case 0: 
                case 10: {
                    writer.writeInt(0);
                    break;
                }
                case 6: {
                    writer.writeFloat(0.0f);
                    break;
                }
                case 11: {
                    writer.writeLong(0L);
                    break;
                }
                case 7: {
                    writer.writeInt(0);
                    writer.writeFloat(0.0f);
                    break;
                }
                default: {
                    assert (false) : "Check: valid type: " + this.iType;
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof StaticValue)) {
            return false;
        }
        return ((StaticValue)aOther).iType == this.iType;
    }

    public int hashCode() {
        return this.iType.type();
    }
}

