/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.util.Hashtable;
import java.util.Vector;
import js.common.ToolProgressMonitor;
import js.tinyvm.ClassPath;
import js.tinyvm.ClassRecord;
import js.tinyvm.ConstantRecord;
import js.tinyvm.EntryClassIndex;
import js.tinyvm.MasterRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.SpecialClassConstants;
import js.tinyvm.SpecialSignatureConstants;
import js.tinyvm.TinyVMException;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.util.HashVector;

public class Binary {
    final RecordTable iEntireBinary = new RecordTable("binary", true, false);
    final MasterRecord iMasterRecord = new MasterRecord(this);
    RecordTable iClassTable = new RecordTable("class table", false, false);
    RecordTable iStaticState = new RecordTable("static state", true, true);
    RecordTable iStaticFields = new RecordTable("static fields", true, false);
    RecordTable iConstantTable = new RecordTable("constants", false, false);
    RecordTable iMethodTables = new RecordTable("methods", true, false);
    RecordTable iExceptionTables = new RecordTable("exceptions", false, false);
    final RecordTable iInstanceFieldTables = new RecordTable("instance fields", true, false);
    final RecordTable iCodeSequences = new RecordTable("code", true, false);
    RecordTable iConstantValues = new RecordTable("constant values", true, false);
    final RecordTable iEntryClassIndices = new RecordTable("entry class indices", true, false);
    final Hashtable iSpecialSignatures = new Hashtable();
    final Hashtable iClasses = new Hashtable();
    final HashVector iSignatures = new HashVector();
    int usedClassCount = 0;
    int markGeneration = 0;

    public void dump(IByteWriter writer) throws TinyVMException {
        this.iEntireBinary.dump(writer);
    }

    protected void addClassRecord(String className, ClassRecord classRecord) {
        assert (className != null) : "Precondition: className != null";
        assert (classRecord != null) : "Precondition: classRecord != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        this.iClasses.put(className, classRecord);
        this.iClassTable.add(classRecord);
    }

    public boolean hasMain(String className) {
        assert (className != null) : "Precondition: className != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        ClassRecord pRec = this.getClassRecord(className);
        return pRec.hasMethod(new Signature("main", "([Ljava/lang/String;)V"), true);
    }

    public ClassRecord getClassRecord(String className) {
        assert (className != null) : "Precondition: className != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        return (ClassRecord)this.iClasses.get(className);
    }

    public int getClassIndex(String className) {
        assert (className != null) : "Precondition: className != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        return this.getClassIndex(this.getClassRecord(className));
    }

    public int getClassIndex(ClassRecord classRecord) {
        if (classRecord == null) {
            return -1;
        }
        return this.iClassTable.indexOf(classRecord);
    }

    public void markClassUsed(ClassRecord classRecord) {
        if (!classRecord.used()) {
            classRecord.markUsed();
            ++this.usedClassCount;
        }
    }

    public int getGeneration() {
        return this.markGeneration;
    }

    public ConstantRecord getConstantRecord(int index) {
        assert (index >= 0) : "Precondition: index >= 0";
        return (ConstantRecord)this.iConstantTable.get(index);
    }

    public int getConstantIndex(ConstantRecord constantRecord) {
        if (constantRecord == null) {
            return -1;
        }
        return this.iConstantTable.indexOf(constantRecord);
    }

    public static Binary createFromClosureOf(String[] entryClassNames, ClassPath classPath, boolean all) throws TinyVMException {
        Binary result = new Binary();
        result.processClasses(entryClassNames, classPath);
        result.processSpecialSignatures();
        result.processConstants();
        result.processMethods(all);
        result.processFields();
        if (!all) {
            result.markUsed(entryClassNames);
            result.processOptimizedClasses();
            result.processOptimizedConstants();
            result.processOptimizedMethods();
            result.processOptimizedFields();
        }
        result.processCode(false);
        result.storeComponents();
        result.initOffsets();
        result.processCode(true);
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    public void processClasses(String[] entryClassNames, ClassPath classPath) throws TinyVMException {
        ClassRecord classRecord;
        String className;
        int i;
        assert (entryClassNames != null) : "Precondition: entryClassNames != null";
        assert (classPath != null) : "Precondition: classPath != null";
        Vector pInterfaceMethods = new Vector();
        String[] specialClasses = SpecialClassConstants.CLASSES;
        for (i = 0; i < specialClasses.length; ++i) {
            className = specialClasses[i];
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            this.addClassRecord(className, classRecord);
        }
        for (i = 0; i < entryClassNames.length; ++i) {
            className = entryClassNames[i];
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            className = classRecord.getName().replace('.', '/');
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            entryClassNames[i] = className;
            this.addClassRecord(className, classRecord);
            classRecord.useAllMethods();
            this.iEntryClassIndices.add(new EntryClassIndex(this, className));
        }
        for (int pIndex = 0; pIndex < this.iClassTable.size(); ++pIndex) {
            ClassRecord classRecord2 = (ClassRecord)this.iClassTable.get(pIndex);
            classRecord2.storeReferredClasses(this.iClasses, this.iClassTable, classPath, pInterfaceMethods);
        }
        int pSize = this.iClassTable.size();
        int pIndex = 0;
        while (pIndex < pSize) {
            classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            for (int i2 = 0; i2 < pInterfaceMethods.size(); ++i2) {
                classRecord.addUsedMethod((String)pInterfaceMethods.elementAt(i2));
            }
            classRecord.iIndex = pIndex++;
            classRecord.initFlags();
            classRecord.initParent();
        }
    }

    public void processOptimizedClasses() throws TinyVMException {
        ClassRecord classRecord;
        int pIndex;
        RecordTable iNewClassTable = new RecordTable("class table", false, false);
        int pSize = this.iClassTable.size();
        for (pIndex = 0; pIndex < pSize; ++pIndex) {
            classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            if (!classRecord.used()) continue;
            iNewClassTable.add(classRecord);
        }
        this.iClassTable = iNewClassTable;
        pSize = this.iClassTable.size();
        for (pIndex = 0; pIndex < pSize; ++pIndex) {
            classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            classRecord.initParent();
        }
    }

    public void markUsed(String[] entryClassNames) throws TinyVMException {
        int classCount;
        int pSize = this.iClassTable.size();
        String[] specialClasses = SpecialClassConstants.CLASSES;
        for (int i = 0; i < specialClasses.length; ++i) {
            String className = specialClasses[i];
            ClassRecord classRecord = this.getClassRecord(className);
            classRecord.markUsed();
        }
        Signature staticInit = new Signature("<clinit>()V");
        Signature runMethod = new Signature("run()V");
        for (int i = 0; i < entryClassNames.length; ++i) {
            ClassRecord classRecord = this.getClassRecord(entryClassNames[i]);
            classRecord.markUsed();
            classRecord.markMethods();
        }
        do {
            ClassRecord classRecord;
            classCount = this.usedClassCount;
            ++this.markGeneration;
            for (int pIndex = 0; pIndex < pSize; ++pIndex) {
                MethodRecord pRec;
                classRecord = (ClassRecord)this.iClassTable.get(pIndex);
                if (!classRecord.used()) continue;
                classRecord.addInterfaces(classRecord);
                classRecord.findHiddenMethods();
                if (classRecord.hasMethod(runMethod, false)) {
                    pRec = classRecord.getMethodRecord(runMethod);
                    classRecord.markMethod(pRec, true);
                }
                if (!classRecord.hasStaticInitializer()) continue;
                pRec = classRecord.getMethodRecord(staticInit);
                classRecord.markMethod(pRec, true);
            }
            for (int i = 0; i < entryClassNames.length; ++i) {
                classRecord = this.getClassRecord(entryClassNames[i]);
                classRecord.markMethods();
            }
        } while (classCount != this.usedClassCount);
    }

    public void processSpecialSignatures() {
        for (int i = 0; i < SpecialSignatureConstants.SIGNATURES.length; ++i) {
            Signature pSig = new Signature(SpecialSignatureConstants.SIGNATURES[i]);
            this.iSignatures.addElement(pSig);
            this.iSpecialSignatures.put(pSig, SpecialSignatureConstants.SIGNATURES[i]);
        }
    }

    public boolean isSpecialSignature(Signature aSig) {
        return this.iSpecialSignatures.containsKey(aSig);
    }

    public void processConstants() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeConstants(this.iConstantTable, this.iConstantValues);
        }
    }

    public void processOptimizedConstants() throws TinyVMException {
        int pSize = this.iConstantTable.size();
        RecordTable iOptConstantTable = new RecordTable("constants", false, false);
        RecordTable iOptConstantValues = new RecordTable("constant values", true, false);
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ConstantRecord pRec = (ConstantRecord)this.iConstantTable.get(pIndex);
            if (!pRec.used()) continue;
            iOptConstantTable.add(pRec);
            iOptConstantValues.add(pRec.constantValue());
        }
        this.iConstantTable = iOptConstantTable;
        this.iConstantValues = iOptConstantValues;
    }

    public void processMethods(boolean iAll) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            classRecord.storeMethods(this.iMethodTables, this.iExceptionTables, this.iSignatures, iAll);
        }
    }

    public void processOptimizedMethods() throws TinyVMException {
        int pSize = this.iClassTable.size();
        this.iMethodTables = new RecordTable("methods", true, false);
        this.iExceptionTables = new RecordTable("exceptions", false, false);
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord classRecord = (ClassRecord)this.iClassTable.get(pIndex);
            classRecord.storeOptimizedMethods(this.iMethodTables, this.iExceptionTables, this.iSignatures);
        }
    }

    public void processFields() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeFields(this.iInstanceFieldTables, this.iStaticFields, this.iStaticState);
        }
    }

    public void processOptimizedFields() throws TinyVMException {
        int pSize = this.iClassTable.size();
        this.iStaticState = new RecordTable("static state", true, true);
        this.iStaticFields = new RecordTable("static fields", true, false);
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeOptimizedFields(this.iInstanceFieldTables, this.iStaticFields, this.iStaticState);
        }
    }

    public void processCode(boolean aPostProcess) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            pRec.storeCode(this.iCodeSequences, aPostProcess);
        }
    }

    public void storeComponents() {
        this.iEntireBinary.add(this.iMasterRecord);
        this.iEntireBinary.add(this.iClassTable);
        this.iEntireBinary.add(this.iStaticState);
        this.iEntireBinary.add(this.iStaticFields);
        this.iEntireBinary.add(this.iConstantTable);
        this.iEntireBinary.add(this.iMethodTables);
        this.iEntireBinary.add(this.iExceptionTables);
        this.iEntireBinary.add(this.iInstanceFieldTables);
        this.iEntireBinary.add(this.iCodeSequences);
        this.iEntireBinary.add(this.iConstantValues);
        this.iEntireBinary.add(this.iEntryClassIndices);
    }

    public void initOffsets() throws TinyVMException {
        this.iEntireBinary.initOffset(0);
    }

    public int getTotalNumMethods() {
        int pTotal = 0;
        int pSize = this.iMethodTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iMethodTables.get(i)).size();
        }
        return pTotal;
    }

    public int getTotalNumInstanceFields() {
        int pTotal = 0;
        int pSize = this.iInstanceFieldTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iInstanceFieldTables.get(i)).size();
        }
        return pTotal;
    }

    public int getTotalNumExceptionRecords() {
        int pTotal = 0;
        int pSize = this.iExceptionTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += ((RecordTable)this.iExceptionTables.get(i)).size();
        }
        return pTotal;
    }

    public void log(ToolProgressMonitor monitor) throws TinyVMException {
        for (int pIndex = 0; pIndex < this.iClassTable.size(); ++pIndex) {
            ClassRecord pRec = (ClassRecord)this.iClassTable.get(pIndex);
            monitor.log("Class " + pIndex + ": " + pRec.getName());
        }
        int pSize = this.iMethodTables.size();
        int methodNo = 0;
        for (int i = 0; i < pSize; ++i) {
            RecordTable rt = (RecordTable)this.iMethodTables.get(i);
            int cnt = rt.size();
            for (int j = 0; j < cnt; ++j) {
                MethodRecord mr = (MethodRecord)rt.get(j);
                monitor.log("Method " + methodNo + ": Class: " + mr.iClassRecord.getName() + " Signature: " + ((Signature)this.iSignatures.elementAt(mr.iSignatureId)).getImage() + " PC " + mr.getCodeStart());
                ++methodNo;
            }
        }
        monitor.log("Master record    : " + this.iMasterRecord.getLength() + " bytes.");
        monitor.log("Class records    : " + this.iClassTable.size() + " (" + this.iClassTable.getLength() + " bytes).");
        monitor.log("Field records    : " + this.getTotalNumInstanceFields() + " (" + this.iInstanceFieldTables.getLength() + " bytes).");
        monitor.log("Static fields    : " + this.iStaticFields.size() + " (" + this.iStaticFields.getLength() + " bytes).");
        monitor.log("Static state     : " + this.iStaticState.size() + " (" + this.iStaticState.getLength() + " bytes).");
        monitor.log("Constant records : " + this.iConstantTable.size() + " (" + this.iConstantTable.getLength() + " bytes).");
        monitor.log("Constant values  : " + this.iConstantValues.size() + " (" + this.iConstantValues.getLength() + " bytes).");
        monitor.log("Method records   : " + this.getTotalNumMethods() + " (" + this.iMethodTables.getLength() + " bytes).");
        monitor.log("Exception records: " + this.getTotalNumExceptionRecords() + " (" + this.iExceptionTables.getLength() + " bytes).");
        monitor.log("Code             : " + this.iCodeSequences.size() + " (" + this.iCodeSequences.getLength() + " bytes).");
        monitor.log("Total            : " + this.iEntireBinary.getLength() + " bytes.");
    }
}

