/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.obex.OBEXOperationDelivery;
import java.io.IOException;
import java.io.OutputStream;

class OBEXOperationOutputStream
extends OutputStream {
    private final OBEXOperationDelivery operation;
    private byte[] buffer;
    private int bufferLength;
    private Object lock = new Object();
    private boolean isClosed = false;

    OBEXOperationOutputStream(int mtu, OBEXOperationDelivery op) {
        this.operation = op;
        this.buffer = new byte[mtu - 11];
        this.bufferLength = 0;
    }

    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.operation.isClosed() || this.isClosed) {
            throw new IOException("stream closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int available;
            for (int written = 0; written < len; written += available) {
                available = this.buffer.length - this.bufferLength;
                if (len - written < available) {
                    available = len - written;
                }
                System.arraycopy(b, off + written, this.buffer, this.bufferLength, available);
                this.bufferLength += available;
                if (this.bufferLength != this.buffer.length) continue;
                this.operation.deliverPacket(false, this.buffer);
                this.bufferLength = 0;
            }
        }
    }

    public void flush() throws IOException {
        this.deliverBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverBuffer(boolean finalPacket) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            byte[] b = new byte[this.bufferLength];
            System.arraycopy(this.buffer, 0, b, 0, this.bufferLength);
            this.operation.deliverPacket(finalPacket, b);
            this.bufferLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        Object object = this.lock;
        synchronized (object) {
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isClosed) {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
                if (!this.operation.isClosed()) {
                    this.deliverBuffer(true);
                }
            }
        }
    }
}

