/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.obex.OBEXClientOperation;
import com.intel.bluetooth.obex.OBEXClientOperationGet;
import com.intel.bluetooth.obex.OBEXClientOperationPut;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.StreamConnection;
import javax.obex.Authenticator;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.Operation;

public class OBEXClientSessionImpl
extends OBEXSessionBase
implements ClientSession {
    private boolean isConnected;
    private OBEXClientOperation operation;
    private static final String FQCN = (class$com$intel$bluetooth$obex$OBEXClientSessionImpl == null ? (class$com$intel$bluetooth$obex$OBEXClientSessionImpl = OBEXClientSessionImpl.class$("com.intel.bluetooth.obex.OBEXClientSessionImpl")) : class$com$intel$bluetooth$obex$OBEXClientSessionImpl).getName();
    private static final Vector fqcnSet = new Vector();
    static /* synthetic */ Class class$com$intel$bluetooth$obex$OBEXClientSessionImpl;

    public OBEXClientSessionImpl(StreamConnection conn, OBEXConnectionParams obexConnectionParams) throws IOException, Error {
        super(conn, obexConnectionParams);
        Utils.isLegalAPICall(fqcnSet);
        this.isConnected = false;
        this.operation = null;
    }

    public HeaderSet createHeaderSet() {
        return OBEXSessionBase.createOBEXHeaderSet();
    }

    public HeaderSet connect(HeaderSet headers) throws IOException {
        return this.connectImpl(headers, false);
    }

    private HeaderSet connectImpl(HeaderSet headers, boolean retry) throws IOException {
        OBEXSessionBase.validateCreatedHeaderSet(headers);
        if (this.isConnected) {
            throw new IOException("Session already connected");
        }
        byte[] connectRequest = new byte[]{16, 0, OBEXUtils.hiByte(this.obexConnectionParams.mtu), OBEXUtils.loByte(this.obexConnectionParams.mtu)};
        this.writeOperation(128, connectRequest, OBEXHeaderSetImpl.toByteArray(headers));
        byte[] b = this.readOperation();
        if (b.length < 6) {
            if (b.length == 3) {
                throw new IOException("Invalid response from OBEX server " + OBEXUtils.toStringObexResponseCodes(b[0]));
            }
            throw new IOException("Invalid response from OBEX server");
        }
        int serverMTU = OBEXUtils.bytesToShort(b[5], b[6]);
        if (serverMTU < 255) {
            throw new IOException("Invalid MTU " + serverMTU);
        }
        if (serverMTU < this.mtu) {
            this.mtu = serverMTU;
        }
        DebugLog.debug("mtu selected", this.mtu);
        OBEXHeaderSetImpl responseHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 7);
        Object connID = responseHeaders.getHeader(203);
        if (connID != null) {
            this.connectionID = (Long)connID;
        }
        this.validateAuthenticationResponse((OBEXHeaderSetImpl)headers, responseHeaders);
        if (!retry && responseHeaders.getResponseCode() == 193) {
            HeaderSet replyHeaders = OBEXHeaderSetImpl.cloneHeaders(headers);
            this.handleAuthenticationChallenge(responseHeaders, (OBEXHeaderSetImpl)replyHeaders);
            return this.connectImpl(replyHeaders, true);
        }
        if (responseHeaders.getResponseCode() == 160) {
            this.isConnected = true;
        }
        return responseHeaders;
    }

    public HeaderSet disconnect(HeaderSet headers) throws IOException {
        OBEXSessionBase.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        if (!this.isConnected) {
            throw new IOException("Session not connected");
        }
        this.writeOperation(129, OBEXHeaderSetImpl.toByteArray(headers));
        byte[] b = this.readOperation();
        this.isConnected = false;
        if (this.operation != null) {
            this.operation.close();
            this.operation = null;
        }
        return OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
    }

    public void setConnectionID(long id) {
        if (id < 0L || id > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid connectionID " + id);
        }
        this.connectionID = id;
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    private void canStartOperation() throws IOException {
        if (!this.isConnected) {
            throw new IOException("Session not connected");
        }
        if (this.operation != null) {
            if (!this.operation.isClosed()) {
                throw new IOException("Client is already in an operation");
            }
            this.operation = null;
        }
    }

    public HeaderSet setPath(HeaderSet headers, boolean backup, boolean create) throws IOException {
        OBEXSessionBase.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        byte[] request = new byte[]{(byte)((backup ? 1 : 0) | (create ? 0 : 2)), 0};
        this.writeOperation(133, request, OBEXHeaderSetImpl.toByteArray(headers));
        byte[] b = this.readOperation();
        return OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
    }

    public Operation get(HeaderSet headers) throws IOException {
        OBEXSessionBase.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        this.writeOperation(131, OBEXHeaderSetImpl.toByteArray(headers));
        byte[] b = this.readOperation();
        OBEXHeaderSetImpl replyHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
        DebugLog.debug0x("GET got reply", replyHeaders.getResponseCode());
        this.operation = new OBEXClientOperationGet(this, replyHeaders);
        return this.operation;
    }

    public Operation put(HeaderSet headers) throws IOException {
        OBEXSessionBase.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        this.operation = new OBEXClientOperationPut(this, headers);
        return this.operation;
    }

    public HeaderSet delete(HeaderSet headers) throws IOException {
        OBEXSessionBase.validateCreatedHeaderSet(headers);
        this.canStartOperation();
        return this.deleteImp(headers);
    }

    HeaderSet deleteImp(HeaderSet headers) throws IOException {
        this.writeOperation(130, OBEXHeaderSetImpl.toByteArray(headers));
        byte[] b = this.readOperation();
        return OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
    }

    public void setAuthenticator(Authenticator auth) {
        if (auth == null) {
            throw new NullPointerException("auth is null");
        }
        this.authenticator = auth;
    }

    public void close() throws IOException {
        if (this.operation != null) {
            this.operation.close();
            this.operation = null;
        }
        super.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fqcnSet.addElement(FQCN);
    }
}

