/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.nxt.comm.NXTConnection;
import lejos.nxt.comm.NXTInputStream;
import lejos.nxt.comm.NXTOutputStream;
import lejos.nxt.comm.USB;

public class USBConnection
implements NXTConnection {
    private static final byte CS_IDLE = 0;
    private static final byte CS_DISCONNECTED = 1;
    private static final byte CS_CONNECTED = 2;
    private static final int USBC_CLOSETIMEOUT1 = 1000;
    private static final int USBC_CLOSETIMEOUT2 = 100;
    byte state = (byte)2;
    NXTInputStream is = null;
    NXTOutputStream os = null;
    int mode;

    public USBConnection(int mode) {
        this.mode = mode;
    }

    public void close() {
        if ((this.mode & 0x20000000) == 0 && this.state == 2) {
            USB.usbWrite(new byte[0], 0, 0);
        }
        USB.waitForDisconnect(1000);
        this.state = 0;
    }

    public InputStream openInputStream() {
        return this.is != null ? this.is : new NXTInputStream(this, 64);
    }

    public OutputStream openOutputStream() {
        return this.os != null ? this.os : new NXTOutputStream(this, 64);
    }

    public DataInputStream openDataInputStream() {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() {
        return new DataOutputStream(this.openOutputStream());
    }

    public int read(byte[] data, int len, boolean wait) {
        if (this.state != 2) {
            return -1;
        }
        while (true) {
            int ret;
            if ((ret = USB.usbRead(data, 0, len)) == -2) {
                if ((this.mode & 0x20000000) == 0) {
                    this.state = 1;
                } else {
                    ret = 0;
                }
            }
            if (ret != 0 || !wait) {
                return ret;
            }
            Thread.yield();
        }
    }

    public int read(byte[] data, int len) {
        return this.read(data, len, true);
    }

    public int write(byte[] data, int len, boolean wait) {
        int written;
        int cnt;
        if (this.state != 2) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        for (written = 0; written < len; written += cnt) {
            cnt = USB.usbWrite(data, written, len - written);
            if (cnt < 0) {
                return written > 0 ? written : -1;
            }
            if (cnt != 0) continue;
            if (!wait) break;
            Thread.yield();
        }
        return written;
    }

    public int write(byte[] data, int len) {
        return this.write(data, len, true);
    }

    public void setIOMode(int mode) {
        this.mode = mode;
    }
}

