/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.io.IOException;
import javax.microedition.io.Connection;
import lejos.nxt.comm.BTConnection;
import lejos.nxt.comm.Bluetooth;

public class RemoteDevice {
    private byte[] addr = new byte[7];
    private String friendlyName;
    private char[] friendlyNameCAr = new char[16];
    private int friendlyNameLen = 0;
    private byte[] deviceClass = new byte[4];

    protected RemoteDevice(byte[] addr) {
        this.addr = addr;
        this.getFriendlyName(true);
    }

    public RemoteDevice(char[] friendlyNameCharArray, int len, byte[] deviceAddr, byte[] devclass) {
        this.setFriendlyName(friendlyNameCharArray, len);
        this.setDeviceAddr(deviceAddr);
        this.setDeviceClass(devclass);
    }

    public static RemoteDevice getRemoteDevice(Connection conn) throws IOException {
        BTConnection btc = (BTConnection)conn;
        return new RemoteDevice(btc.getAddress());
    }

    public void setDeviceAddr(byte[] deviceAddr) {
        for (int i = 0; i < 7; ++i) {
            this.addr[i] = deviceAddr[i];
        }
    }

    public byte[] getDeviceAddr() {
        return this.addr;
    }

    public void setFriendlyName(char[] friendlyNameCharArray, int len) {
        for (int i = 0; i < len; ++i) {
            this.friendlyNameCAr[i] = friendlyNameCharArray[i];
        }
        this.friendlyNameLen = len;
    }

    public String getFriendlyName(boolean alwaysAsk) {
        if (alwaysAsk) {
            String name = Bluetooth.lookupName(this.addr);
            this.friendlyNameCAr = name.toCharArray();
            this.friendlyNameLen = name.length();
        }
        return new String(this.friendlyNameCAr, 0, this.friendlyNameLen);
    }

    public int getFriendlyName(char[] friendlyNameCharArray) {
        for (int i = 0; i < this.friendlyNameLen; ++i) {
            friendlyNameCharArray[i] = this.friendlyNameCAr[i];
        }
        return this.friendlyNameLen;
    }

    public void setDeviceClass(byte[] devclass) {
        for (int i = 0; i < 4; ++i) {
            this.deviceClass[i] = devclass[i];
        }
    }

    public String getBluetoothAddress() {
        return Bluetooth.addressToString(this.addr);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof RemoteDevice && ((RemoteDevice)obj).getBluetoothAddress().equals(this.getBluetoothAddress());
    }

    public byte[] getDeviceClass() {
        return this.deviceClass;
    }
}

