/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import lejos.pc.comm.FileInfo;
import lejos.pc.comm.InputValues;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTCommLogListener;
import lejos.pc.comm.NXTInfo;
import lejos.pc.comm.NXTProtocol;
import lejos.pc.comm.OutputState;

public class NXTCommand
implements NXTProtocol {
    private Collection<NXTCommLogListener> fLogListeners = new ArrayList<NXTCommLogListener>();
    private NXTComm nxtComm = null;
    private NXTComm nxtCommUSB = null;
    private NXTComm nxtCommBluetooth = null;
    private static NXTCommand singleton = null;
    private boolean verifyCommand = false;
    private boolean open = false;
    private static String hexChars = "01234567890abcdef";

    private NXTCommand() {
    }

    public NXTInfo[] search(String name, int protocol) throws NXTCommException {
        NXTInfo[] nxtInfos;
        if (this.nxtComm == null) {
            try {
                if ((protocol & 1) != 0) {
                    this.nxtCommUSB = NXTCommFactory.createNXTComm(1);
                }
            }
            catch (NXTCommException e) {
                this.log(e);
            }
            try {
                if ((protocol & 1) != 0) {
                    this.nxtCommBluetooth = NXTCommFactory.createNXTComm(2);
                }
            }
            catch (NXTCommException e) {
                this.log(e);
            }
            if (this.nxtCommUSB == null && this.nxtCommBluetooth == null) {
                throw new NXTCommException("Cannot load a comm driver");
            }
        }
        if ((protocol & 1) != 0 && this.nxtCommUSB != null && (nxtInfos = this.nxtCommUSB.search(name, protocol)).length > 0) {
            this.nxtComm = this.nxtCommUSB;
            return nxtInfos;
        }
        if ((protocol & 2) != 0 && this.nxtCommBluetooth != null && (nxtInfos = this.nxtCommBluetooth.search(name, protocol)).length > 0) {
            this.nxtComm = this.nxtCommBluetooth;
            return nxtInfos;
        }
        return new NXTInfo[0];
    }

    public void setNXTCommBlueTooth() throws NXTCommException {
        if (this.nxtComm == null) {
            this.nxtComm = NXTCommFactory.createNXTComm(2);
        }
    }

    public boolean open(NXTInfo nxt) throws NXTCommException {
        this.open = this.nxtComm.open(nxt);
        return this.open;
    }

    public void setVerify(boolean verify) {
        this.verifyCommand = verify;
    }

    private byte sendRequest(byte[] request, int replyLen) throws IOException {
        byte verify = 0;
        if (this.verifyCommand) {
            request[0] = 0;
        }
        byte[] reply = this.nxtComm.sendRequest(request, request[0] == 0 ? replyLen : 0);
        if (request[0] == 0) {
            verify = reply[2];
        }
        return verify;
    }

    private byte sendSystemRequest(byte[] request, int replyLen) throws IOException {
        byte verify = 0;
        if (this.verifyCommand) {
            request[0] = 1;
        }
        byte[] reply = this.nxtComm.sendRequest(request, request[0] == 1 ? replyLen : 0);
        if (request[0] == 1) {
            verify = reply[2];
        }
        return verify;
    }

    public byte startProgram(String fileName) throws IOException {
        byte[] request = new byte[]{-128, 0};
        request = this.appendString(request, fileName);
        return this.sendRequest(request, 22);
    }

    public FileInfo openRead(String fileName) throws IOException {
        byte[] request = new byte[]{1, -128};
        request = this.appendString(request, fileName);
        byte[] reply = this.nxtComm.sendRequest(request, 8);
        FileInfo fileInfo = new FileInfo(fileName);
        fileInfo.status = reply[2];
        if (reply.length == 8) {
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[4] | (0xFF & reply[5]) << 8 | (0xFF & reply[6]) << 16 | (0xFF & reply[7]) << 24;
        }
        return fileInfo;
    }

    public byte openWrite(String fileName, int size) throws IOException {
        byte[] command = new byte[]{1, -127};
        byte[] asciiFileName = new byte[fileName.length()];
        for (int i = 0; i < fileName.length(); ++i) {
            asciiFileName[i] = (byte)fileName.charAt(i);
        }
        command = this.appendBytes(command, asciiFileName);
        byte[] request = new byte[22];
        System.arraycopy(command, 0, request, 0, command.length);
        byte[] fileLength = new byte[]{(byte)size, (byte)(size >>> 8), (byte)(size >>> 16), (byte)(size >>> 24)};
        request = this.appendBytes(request, fileLength);
        byte[] reply = this.nxtComm.sendRequest(request, 4);
        if (reply == null || reply.length != 4) {
            throw new IOException("Invalid return from OPEN WRITE");
        }
        if (reply[2] != 0) {
            if (reply[2] == -5) {
                throw new IOException("NXJ Flash Memory Full");
            }
            if (reply[2] == -4) {
                throw new IOException("NXJ Directory Full");
            }
            throw new IOException("OPEN WRITE failed");
        }
        return reply[3];
    }

    public byte closeFile(byte handle) throws IOException {
        byte[] request = new byte[]{-127, -124, handle};
        return this.sendSystemRequest(request, 4);
    }

    public byte delete(String fileName) throws IOException {
        byte[] request = new byte[]{1, -123};
        request = this.appendString(request, fileName);
        return this.sendSystemRequest(request, 23);
    }

    public FileInfo findFirst(String wildCard) throws IOException {
        byte[] request = new byte[]{1, -74};
        request = this.appendString(request, wildCard);
        byte[] reply = this.nxtComm.sendRequest(request, 32);
        FileInfo fileInfo = null;
        if (reply[2] == 0 && reply.length == 32) {
            StringBuffer name = new StringBuffer(new String(reply)).delete(0, 4);
            int lastPos = name.indexOf("\u0000");
            if (lastPos < 0 || lastPos > 20) {
                lastPos = 20;
            }
            name.delete(lastPos, name.length());
            fileInfo = new FileInfo(name.toString());
            fileInfo.status = 0;
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[24] | (0xFF & reply[25]) << 8 | (0xFF & reply[26]) << 16 | (0xFF & reply[27]) << 24;
            fileInfo.startPage = 0xFF & reply[28] | (0xFF & reply[29]) << 8 | (0xFF & reply[30]) << 16 | (0xFF & reply[31]) << 24;
        }
        return fileInfo;
    }

    public FileInfo findNext(byte handle) throws IOException {
        byte[] request = new byte[]{1, -73, handle};
        byte[] reply = this.nxtComm.sendRequest(request, 32);
        FileInfo fileInfo = null;
        if (reply[2] == 0 && reply.length == 32) {
            StringBuffer name = new StringBuffer(new String(reply)).delete(0, 4);
            int lastPos = name.indexOf("\u0000");
            if (lastPos < 0 || lastPos > 20) {
                lastPos = 20;
            }
            name.delete(lastPos, name.length());
            fileInfo = new FileInfo(name.toString());
            fileInfo.status = 0;
            fileInfo.fileHandle = reply[3];
            fileInfo.fileSize = 0xFF & reply[24] | (0xFF & reply[25]) << 8 | (0xFF & reply[26]) << 16 | (0xFF & reply[27]) << 24;
            fileInfo.startPage = 0xFF & reply[28] | (0xFF & reply[29]) << 8 | (0xFF & reply[30]) << 16 | (0xFF & reply[31]) << 24;
        }
        return fileInfo;
    }

    private byte[] appendString(byte[] command, String str) {
        int i;
        byte[] buff = new byte[command.length + str.length() + 1];
        for (i = 0; i < command.length; ++i) {
            buff[i] = command[i];
        }
        for (i = 0; i < str.length(); ++i) {
            buff[command.length + i] = (byte)str.charAt(i);
        }
        buff[command.length + str.length()] = 0;
        return buff;
    }

    private byte[] appendBytes(byte[] array1, byte[] array2) {
        byte[] array = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    public int getBatteryLevel() throws IOException {
        byte[] request = new byte[]{0, 11};
        byte[] reply = this.nxtComm.sendRequest(request, 5);
        int batteryLevel = 0xFF & reply[3] | (0xFF & reply[4]) << 8;
        return batteryLevel;
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        byte[] request = new byte[]{-127, 32};
        this.nxtComm.sendRequest(request, 0);
        this.nxtComm.close();
    }

    public byte writeFile(byte handle, byte[] data) throws IOException {
        byte[] request = new byte[data.length + 3];
        byte[] command = new byte[]{-127, -125, handle};
        System.arraycopy(command, 0, request, 0, command.length);
        System.arraycopy(data, 0, request, 3, data.length);
        return this.sendSystemRequest(request, 6);
    }

    public byte[] readFile(byte handle, int length) throws IOException {
        byte[] request = new byte[]{1, -126, handle, (byte)length, (byte)(length >>> 8)};
        byte[] reply1 = this.nxtComm.sendRequest(request, length + 6);
        int dataLen = (reply1[4] & 0xFF) + (reply1[5] << 8 & 0xFF);
        byte[] reply = new byte[dataLen];
        for (int i = 0; i < dataLen; ++i) {
            reply[i] = reply1[i + 6];
        }
        return reply;
    }

    public byte defrag() throws IOException {
        byte[] request = new byte[]{-127, 33};
        return this.sendSystemRequest(request, 3);
    }

    public String getFriendlyName() throws IOException {
        byte[] request = new byte[]{1, -101};
        byte[] reply = this.nxtComm.sendRequest(request, 33);
        char[] nameChars = new char[16];
        int len = 0;
        for (int i = 0; i < 15 && reply[i + 3] != 0; ++i) {
            nameChars[i] = (char)reply[i + 3];
            ++len;
        }
        return new String(nameChars, 0, len);
    }

    public byte setFriendlyName(String name) throws IOException {
        byte[] request = new byte[]{-127, -104};
        request = this.appendString(request, name);
        return this.sendSystemRequest(request, 3);
    }

    public String getLocalAddress() throws IOException {
        byte[] request = new byte[]{1, -101};
        byte[] reply = this.nxtComm.sendRequest(request, 33);
        char[] addrChars = new char[14];
        for (int i = 0; i < 7; ++i) {
            addrChars[i * 2] = hexChars.charAt(reply[i + 18] >> 4 & 0xF);
            addrChars[i * 2 + 1] = hexChars.charAt(reply[i + 18] & 0xF);
        }
        return new String(addrChars);
    }

    public InputValues getInputValues(int port) throws IOException {
        byte[] request = new byte[]{0, 7, (byte)port};
        byte[] reply = this.nxtComm.sendRequest(request, 16);
        InputValues inputValues = new InputValues();
        inputValues.inputPort = reply[3];
        inputValues.valid = reply[4] != 0;
        inputValues.isCalibrated = reply[5] == 0;
        inputValues.sensorType = reply[6];
        inputValues.sensorMode = reply[7];
        inputValues.rawADValue = 0xFF & reply[8] | (0xFF & reply[9]) << 8;
        inputValues.normalizedADValue = 0xFF & reply[10] | (0xFF & reply[11]) << 8;
        inputValues.scaledValue = (short)(0xFF & reply[12] | reply[13] << 8);
        inputValues.calibratedValue = (short)(0xFF & reply[14] | reply[15] << 8);
        return inputValues;
    }

    public OutputState getOutputState(int port) throws IOException {
        byte[] request = new byte[]{0, 6, (byte)port};
        byte[] reply = this.nxtComm.sendRequest(request, 25);
        if (reply[1] != 6) {
            System.out.println("Oops! Error in NXTCommand.getOutputState.");
            System.out.println("Return data did not match request.");
            System.out.println("reply[0] = " + reply[0] + "  reply[1] = " + reply[1] + "  reply[2] = " + reply[2]);
        }
        OutputState outputState = new OutputState(port);
        outputState.status = reply[2];
        outputState.outputPort = reply[3];
        outputState.powerSetpoint = reply[4];
        outputState.mode = reply[5];
        outputState.regulationMode = reply[6];
        outputState.turnRatio = reply[7];
        outputState.runState = reply[8];
        outputState.tachoLimit = 0xFF & reply[9] | (0xFF & reply[10]) << 8 | (0xFF & reply[11]) << 16 | (0xFF & reply[12]) << 24;
        outputState.tachoCount = 0xFF & reply[13] | (0xFF & reply[14]) << 8 | (0xFF & reply[15]) << 16 | (0xFF & reply[16]) << 24;
        outputState.blockTachoCount = 0xFF & reply[17] | (0xFF & reply[18]) << 8 | (0xFF & reply[19]) << 16 | (0xFF & reply[20]) << 24;
        outputState.rotationCount = 0xFF & reply[21] | (0xFF & reply[22]) << 8 | (0xFF & reply[23]) << 16 | (0xFF & reply[24]) << 24;
        return outputState;
    }

    public byte[] messageRead(byte remoteInbox, byte localInbox, boolean remove) throws IOException {
        byte[] request = new byte[]{0, 19, remoteInbox, localInbox, remove ? (byte)1 : 0};
        byte[] reply = this.nxtComm.sendRequest(request, 64);
        byte[] message = new byte[reply[4]];
        System.arraycopy(reply, 5, message, 0, reply[4]);
        return message;
    }

    public static NXTCommand getSingleton() {
        if (singleton == null) {
            singleton = new NXTCommand();
        }
        return singleton;
    }

    public void addLogListener(NXTCommLogListener listener) {
        this.fLogListeners.add(listener);
    }

    public void removeLogListener(NXTCommLogListener listener) {
        this.fLogListeners.remove(listener);
    }

    private void log(String message) {
        for (NXTCommLogListener listener : this.fLogListeners) {
            listener.logEvent(message);
        }
    }

    private void log(Throwable t) {
        for (NXTCommLogListener listener : this.fLogListeners) {
            listener.logEvent(t);
        }
    }
}

