############################################################## -*- Makefile -*-
#
# Makefile for nodoka
#
###############################################################################


#!if "$(VERSION)" == ""
!if ( "$(RETAIL)" == "1" )
VERSION		= 4.06
!else
VERSION		= 4.06_sample
!endif

!if "$(TARGETOS)" == "WINNT"
OS_SPECIFIC_DEFINES	=  -DUNICODE -D_UNICODE
DISTRIB_OS	= xp
!endif

!if "$(TARGETOS)" == "WIN95"
OS_SPECIFIC_DEFINES	=  -D_MBCS
DISTRIB_OS	= 9x
!endif

!if "$(TARGETOS)" == "BOTH"
!error You must specify TARGETOS=WINNT
!endif

BOOST_DIR	= ../boost_$(BOOST_VER)_0
COMMON_DEFINES	= -DSTRICT -D_WIN32_IE=0x0500 $(OS_SPECIFIC_DEFINES)


# nodoka.exe	###############################################################

TARGET_1	= $(OUT_DIR)\nodoka.exe
OBJS_1		=					\
		$(OUT_DIR)\compiler_specific_func.obj	\
		$(OUT_DIR)\dlgeditsetting.obj		\
		$(OUT_DIR)\dlginvestigate.obj		\
		$(OUT_DIR)\dlglog.obj			\
		$(OUT_DIR)\dlgsetting.obj		\
		$(OUT_DIR)\dlgversion.obj		\
		$(OUT_DIR)\engine.obj			\
		$(OUT_DIR)\focus.obj			\
		$(OUT_DIR)\function.obj			\
		$(OUT_DIR)\keyboard.obj			\
		$(OUT_DIR)\keymap.obj			\
		$(OUT_DIR)\layoutmanager.obj	\
		$(OUT_DIR)\nodoka.obj			\
		$(OUT_DIR)\parser.obj			\
		$(OUT_DIR)\registry.obj			\
		$(OUT_DIR)\setting.obj			\
		$(OUT_DIR)\stringtool.obj		\
		$(OUT_DIR)\target.obj			\
		$(OUT_DIR)\vkeytable.obj		\
		$(OUT_DIR)\windowstool.obj		\

SRCS_1		=				\
		compiler_specific_func.cpp	\
		dlgeditsetting.cpp		\
		dlginvestigate.cpp		\
		dlglog.cpp				\
		dlgsetting.cpp			\
		dlgversion.cpp			\
		engine.cpp				\
		focus.cpp				\
		function.cpp			\
		keyboard.cpp			\
		keymap.cpp				\
		layoutmanager.cpp		\
		nodoka.cpp				\
		parser.cpp				\
		registry.cpp			\
		setting.cpp				\
		stringtool.cpp			\
		target.cpp				\
		vkeytable.cpp			\
		windowstool.cpp			\

RES_1		= $(OUT_DIR)\nodoka.res

LIBS_1		=					\
		$(guixlibsmt)			\
		shell32.lib				\
		comctl32.lib			\
		wtsapi32.lib			\
		psapi.lib				\
		shlwapi.lib				\
		$(OUT_DIR)\nodoka.lib	\

EXTRADEP_1	= $(OUT_DIR)\nodoka.lib

# nodoka.dll	###############################################################

TARGET_2	= $(OUT_DIR)\nodoka.dll
OBJS_2		= $(OUT_DIR)\hook.obj $(OUT_DIR)\stringtool.obj
SRCS_2		= hook.cpp stringtool.cpp
LIBS_2		= $(guixlibsmt) imm32.lib


# nodoka.lib	###############################################################

TARGET_3	= $(OUT_DIR)\nodoka.lib
DLL_3		= $(OUT_DIR)\nodoka.dll


# distribution	###############################################################

DISTRIB_SETTINGS =			\
		104.nodoka			\
		104on109.nodoka		\
		109.nodoka			\
		109on104.nodoka		\
		default.nodoka		\
		default2.nodoka		\
		emacsedit.nodoka	\
		dot.nodoka			\

DISTRIB_MANUAL	=				\
		doc\banner-ja.gif		\
		doc\CONTENTS-ja.html		\
		doc\CONTENTS-en.html		\
		doc\CUSTOMIZE-ja.html		\
		doc\CUSTOMIZE-en.html		\
		doc\edit-setting-ja.png		\
		doc\investigate-ja.png		\
		doc\log-ja.png			\
		doc\MANUAL-ja.html		\
		doc\MANUAL-en.html		\
		doc\menu-ja.png			\
		doc\pause-ja.png		\
		doc\README-ja.html		\
		doc\README-en.html		\
		doc\README.css			\
		doc\setting-ja.png		\
		doc\syntax.txt			\
		doc\target.png			\
		doc\version-ja.png		\
		doc\tasktray-icon.png	\
		doc\copy-ja.png			\
		doc\virtualstore-ja.png	\
		doc\icon0.png	\
		doc\icon1.png	\
		doc\icon2.png	\
		doc\icon3.png	\
		doc\icon4.png	\
		doc\icon5.png	\
		doc\icon6.png	\
		doc\icon7.png	\
		doc\regedit.png	\
		doc\keyboard.html	\
		doc\104.gif	\
		doc\109.gif	\
		doc\keyboard_vsd.pdf	\
		readme.txt			\
		readme-en.txt			\
		nshell.txt			\
		Common_Public_License_1_0.txt	\
		Common_Public_License_1_0_JP.txt	\
		nshell.exe			\
		nodoka-mode.el			\

DISTRIB_CONTRIBS =				\
		contrib\109onAX.nodoka		\
		contrib\nodoka-settings.txt	\
		contrib\dvorak.nodoka		\
		contrib\dvorak109.nodoka		\
		contrib\keitai.nodoka		\
		contrib\ax.nodoka			\
		contrib\98x1.nodoka		\
		contrib\DVORAKon109.nodoka	\

DISTRIB_TS4NODOKA =				\
		ts4nodoka\thumbsense.nodoka		\
		ts4nodoka\sts4nodoka.dll		\
		ts4nodoka\cts4nodoka.dll		\
		

!if "$(TARGETOS)" == "WINNT"
DISTRIB_DRIVER	=				\
		d\i386\nodokad.sys		\
		d\amd64\nodokadx64.sys		\
		d\rescue\i386\nodokadrsc.sys	\
		d\rescue\amd64\nodokadx64rsc.sys
!endif
!if "$(TARGETOS)" == "WIN95"
DISTRIB_DRIVER	= d_win9x\nodokad.vxd
!endif

DISTRIB		=			\
		$(TARGET_1)		\
		$(TARGET_2)		\
		s\$(OUT_DIR)\setup.exe	\
		$(DISTRIB_SETTINGS)	\
		$(DISTRIB_MANUAL)	\
		$(DISTRIB_CONTRIBS)	\
		$(DISTRIB_DRIVER)	\
		$(DISTRIB_TS4NODOKA)	\


# tools		###############################################################

IEXPRESS	= iexpress
DOCXX		= doc++.exe
MAKEDEPEND	= perl tools/makedepend -o.obj
DOS2UNIX	= perl tools/dos2unix
UNIX2DOS	= perl tools/unix2dos
MAKEFUNC	= perl tools/makefunc
GETCVSFILES	= perl tools/getcvsfiles
GENIEXPRESS	= perl tools/geniexpress


# rules		###############################################################

all:		boost $(OUT_DIR) $(TARGET_1) $(TARGET_2) $(TARGET_3)

$(OUT_DIR):
		if not exist "$(OUT_DIR)\\" $(MKDIR) $(OUT_DIR)

functions.h:	engine.h tools/makefunc
		$(MAKEFUNC) < engine.h > functions.h

$(OUT_DIR)\nodoka.res:	nodoka.manifest

clean::
		-$(RM) $(TARGET_1) $(TARGET_2) $(TARGET_3)
		-$(RM) $(OUT_DIR)\*.obj
		-$(RM) $(OUT_DIR)\*.res $(OUT_DIR)\*.exp
		-$(RM) nodoka.aps nodoka.opt $(OUT_DIR)\*.pdb
		-$(RM) *~ $(CLEAN)
		-$(RMDIR) $(OUT_DIR)

depend::
		$(MAKEDEPEND) -fnodoka-common.mak \
		-- $(DEPENDFLAGS) -- $(SRCS_1) $(SRCS_2)

distrib:
		-@echo "we need cygwin tool"
		-rm -f nodoka-$(VERSION) 
		-ln -s . nodoka-$(VERSION)
		-bash -c "tar cvjf nodoka-$(VERSION)-src.tar.bz2 `$(GETCVSFILES) | sed 's/^./nodoka-$(VERSION)/'`"
		-rm -f nodoka-$(VERSION) 
		-$(GENIEXPRESS) \
			nodoka-$(VERSION)$(SAMPLE_NAME)_setup.exe \
			"NODOKA $(VERSION)" \
			setup.exe $(DISTRIB) > __nodoka__.sed
#		-$(UNIX2DOS) $(DISTRIB_SETTINGS) $(DISTRIB_CONTRIBS)
		-$(IEXPRESS) /N __nodoka__.sed
#		-$(DOS2UNIX) $(DISTRIB_SETTINGS) $(DISTRIB_CONTRIBS)
		-$(RM) __nodoka__.sed

srcdesc::
		@$(ECHO) USE DOC++ 3.4.4 OR HIGHER
		$(DOCXX) *.h

# DO NOT DELETE

$(OUT_DIR)\compiler_specific_func.obj: compiler_specific.h \
 compiler_specific_func.h misc.h stringtool.h
$(OUT_DIR)\dlgeditsetting.obj: compiler_specific.h dlgeditsetting.h \
 layoutmanager.h nodokarc.h misc.h stringtool.h windowstool.h
$(OUT_DIR)\dlginvestigate.obj: compiler_specific.h d\ioctl.h \
 dlginvestigate.h driver.h engine.h focus.h function.h functions.h hook.h \
 keyboard.h keymap.h nodokarc.h misc.h msgstream.h multithread.h parser.h \
 setting.h stringtool.h target.h vkeytable.h windowstool.h
$(OUT_DIR)\dlglog.obj: compiler_specific.h dlglog.h layoutmanager.h nodoka.h \
 nodokarc.h misc.h msgstream.h multithread.h registry.h stringtool.h \
 windowstool.h
$(OUT_DIR)\dlgsetting.obj: compiler_specific.h d\ioctl.h dlgeditsetting.h \
 driver.h function.h functions.h keyboard.h keymap.h layoutmanager.h nodoka.h \
 nodokarc.h misc.h multithread.h parser.h registry.h setting.h stringtool.h \
 windowstool.h
$(OUT_DIR)\dlgversion.obj: compiler_specific.h compiler_specific_func.h \
 layoutmanager.h nodoka.h nodokarc.h misc.h stringtool.h windowstool.h
$(OUT_DIR)\engine.obj: compiler_specific.h d\ioctl.h driver.h engine.h \
 errormessage.h function.h functions.h hook.h keyboard.h keymap.h nodokarc.h \
 misc.h msgstream.h multithread.h parser.h setting.h stringtool.h \
 windowstool.h
$(OUT_DIR)\focus.obj: compiler_specific.h focus.h misc.h stringtool.h \
 windowstool.h
$(OUT_DIR)\function.obj: compiler_specific.h d\ioctl.h driver.h engine.h \
 function.h functions.h hook.h keyboard.h keymap.h nodoka.h nodokarc.h misc.h \
 msgstream.h multithread.h parser.h registry.h setting.h stringtool.h \
 vkeytable.h windowstool.h
$(OUT_DIR)\keyboard.obj: compiler_specific.h d\ioctl.h driver.h keyboard.h \
 misc.h stringtool.h
$(OUT_DIR)\keymap.obj: compiler_specific.h d\ioctl.h driver.h \
 errormessage.h function.h functions.h keyboard.h keymap.h misc.h \
 multithread.h parser.h setting.h stringtool.h
$(OUT_DIR)\layoutmanager.obj: compiler_specific.h layoutmanager.h misc.h \
 stringtool.h windowstool.h
$(OUT_DIR)\nodoka.obj: compiler_specific.h compiler_specific_func.h d\ioctl.h \
 dlginvestigate.h dlglog.h dlgsetting.h dlgversion.h driver.h engine.h \
 errormessage.h focus.h function.h functions.h hook.h keyboard.h keymap.h \
 nodoka.h nodokaipc.h nodokarc.h misc.h msgstream.h multithread.h parser.h \
 registry.h setting.h stringtool.h target.h windowstool.h
$(OUT_DIR)\parser.obj: compiler_specific.h errormessage.h misc.h parser.h \
 stringtool.h
$(OUT_DIR)\registry.obj: array.h compiler_specific.h misc.h registry.h \
 stringtool.h
$(OUT_DIR)\setting.obj: array.h compiler_specific.h d\ioctl.h dlgsetting.h \
 driver.h errormessage.h function.h functions.h keyboard.h keymap.h nodoka.h \
 nodokarc.h misc.h multithread.h parser.h registry.h setting.h stringtool.h \
 vkeytable.h windowstool.h
$(OUT_DIR)\stringtool.obj: array.h compiler_specific.h misc.h stringtool.h
$(OUT_DIR)\target.obj: compiler_specific.h nodokarc.h misc.h stringtool.h \
 target.h windowstool.h
$(OUT_DIR)\vkeytable.obj: compiler_specific.h misc.h vkeytable.h
$(OUT_DIR)\windowstool.obj: array.h compiler_specific.h misc.h stringtool.h \
 windowstool.h
$(OUT_DIR)\hook.obj: compiler_specific.h hook.h misc.h stringtool.h
$(OUT_DIR)\stringtool.obj: array.h compiler_specific.h misc.h stringtool.h
