#pragma once




//^`
/////////////////////////////////////////////////



typedef VOID(*NicoLiveOnSend)(NicoLiveStream_P self);

//
//jRjRIuWFNg
////////////////////////////////////////////////////////////////////


typedef struct {
	NicoLiveHeartBeat heartBeat;
	LPTSTR is_restrictBuff;
	INT_PTR is_restrictSize;
	LPTSTR ticketBuff;
	INT_PTR ticketSize;
//	NLIB_RESULT error;

}NicoLiveHeartBeatContainer,*NicoLiveHeartBeatContainer_P;



#define LENGTH_NICOLIVEID			LENGTH_256


#define NICOLIVE_CHAT_RECEVE_LENGTH			LENGTH_65536
#define NICOLIVE_CHATTEXT_LENGTH			LENGTH_4096
typedef struct {

	HANDLE hRecvChatHandle;
	unsigned recvChatThreadID;
	HANDLE hHeartBeatHandle;
	unsigned heartBeatThreadID;
	HANDLE hKeapALiveHandle;
	unsigned keapALiveThreadID;
	CHAR recvBuf[NICOLIVE_CHAT_RECEVE_LENGTH];
	SOCKET sock;

	WSAEVENT setHeartBeatTimeEvent;
	DWORD heartBeatTime;
	BOOL heartBeatFlag;
	NicoLiveOnSend onHeartBeatSend;

#ifdef USE_NLIB_KEEPALIVE
	WSAEVENT setKeepAliveTimeEvent;
	DWORD keepAliveTime;
	BOOL keapALiveFlag;
	NicoLiveOnSend onKeepAlliveSend;
#define RESETEVENT_SIZE 3
#define KEEPALLIVERESETEVENT 2
#else

#define RESETEVENT_SIZE 2

#endif//USE_NLIB_KEEPALIVE

	WSAEVENT deleteEvent;
	WSAEVENT startEvent;
	WSAEVENT  endEvent;
	WSAEVENT resetEvents[RESETEVENT_SIZE];
	UINT_PTR chatNo;
	UINT_PTR commentCountSum;
	DWORD commentStartTime;
	time_t baseVpos;
}ChatManager,*ChatManager_P;

///
///Xe[^X
///
typedef struct streamstatus_t{
#ifdef PLAYERSTATUS_GET_TITLE
	TCHAR title[LENGTH_256];
#endif
	TCHAR id[LENGTH_128];
	TCHAR default_community[LENGTH_128];
	PROVIDERTYPE provider_type;
	BOOL  is_owner;
	time_t start_time;
	time_t end_time;
	time_t open_time;
	time_t base_time;
}StreamStatus,*StreamStatus_P;

///bZ[WT[o[Xe[^X
typedef struct messageserver_t{

	TCHAR addr[LENGTH_IP];
	TCHAR port[LENGTH_32];
	UINT_PTR thread;
	


}MessageServerStatus;


typedef struct{

	UINT_PTR is_premium;
	TCHAR user_id[LENGTH_128];
	TCHAR userDomain[LENGTH_128];
}NicoLivePSOwn,*NicoLivePSOwn_P;


///jRjRXe[^X
typedef struct nicoliveplayerstatus_t{
	StreamStatus			stream;
	MessageServerStatus		ms;
	NicoLivePSOwn			user;
}NicoLivePlayerStatus,*NicoLivePlayerStatus_P;


//jRjRXe[^X
typedef struct nicolivepublishstatus_t{

	TCHAR token[LENGTH_256];
}NicoLivePublishStatus,*NicoLivePublishStatus_P;

typedef struct {
	HINTERNET getPlayerStatusSession;
	HINTERNET getPublishStatusSession;
	HINTERNET heartBeatSession;
	CRITICAL_SECTION cs;
}SessionManager,*SessionManager_P;



#define USERSESSION_LENGTH	LENGTH_256
#define NICOLIVEHISTORY_LENGTH		LENGTH_256

typedef struct nicolivestream_t{
	TCHAR userSession[USERSESSION_LENGTH];
#ifdef USE_NLIB_LIVEHISTORY
	TCHAR nicoLiveHistory[NICOLIVEHISTORY_LENGTH];
#endif
	TCHAR ticket[LENGTH_256];
	LPVOID option;
	NicoLivePlayerStatus playerStatus;
	NicoLivePublishStatus publishStatus;
	ChatManager chatManager;
	NicoRecvCallBack callBack;
	INT_PTR res_from;
	SessionManager sessionManager;
	NLIB_RESULT error;
	BOOL isConnecting;
}NicoLiveStream;


extern BOOL Initialize_NicoLive();


extern BOOL Finalize_NicoLive();

