package net.atlabo.money.receiver;

import java.util.Calendar;
import java.util.GregorianCalendar;

import net.atlabo.money.logic.WidgetLogic;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

/**
 * 삷郌V[o
 * T[rX̍XV{
 * @author Atsushi Nakamoto
 *
 */
public class DailyReceiver extends BroadcastReceiver {

	public static final String ACTION_DAILY = "ACTION_DAILY";

	@Override
	public void onReceive(Context context, Intent intent) {
		Log.v("money", "DailyReceiver#onReceive start!!");

        // ̓ɃV[o𓮍삳悤ɃZbg
        Intent receiverIntent = new Intent(context, DailyReceiver.class);
        receiverIntent.setAction(ACTION_DAILY);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, receiverIntent, 0);

        // 100:00ݒ
        Calendar cal = new GregorianCalendar();
        cal.add(Calendar.DAY_OF_MONTH, 1);
        cal.set(Calendar.HOUR, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);

        // AlarmManagerݒ肷
        AlarmManager manager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        manager.cancel(pendingIntent);
        manager.set(AlarmManager.RTC_WAKEUP, cal.getTimeInMillis(), pendingIntent);

		// T[rXĂяo
        WidgetLogic logic = new WidgetLogic();
        logic.execute(context);
	}

}
