package net.atlabo.money.logic;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import net.atlabo.money.R;
import net.atlabo.money.activity.DailyDetailActivity;
import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.PlanMonthDao;
import net.atlabo.money.util.Preference;
import net.atlabo.money.widget.MoneyWidget;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.widget.RemoteViews;

/**
 * WidgetĂяoServiceNXB
 * x̃[hs
 * @author Atsushi Nakamoto
 *
 */
public class WidgetLogic {
	private static final String dateFormat = "yyyyMMdd";
	private static final String dateFormat2 = "yyyyNMd";
	private static final String dateFormat3 = "yyyyMM";
	private DecimalFormat decimalFormat = new DecimalFormat("###,###,###~");
	public static final String BUTTON_CLICK_ACTION = "BUTTON_CLICK_ACTION";


	public void execute(Context context) {
		RemoteViews views = new RemoteViews(context.getPackageName(), R.layout.widget);

		// {擾
		Date date = new Date();
		
		// {̎gp擾
		SimpleDateFormat df = new SimpleDateFormat(dateFormat);
		ConnectionManager manager = ConnectionManager.getInstance(context);
		BudgetDao dao = new BudgetDao(manager);
		
		// NWbg^C~O擾
		Preference pref = new Preference(context);
		String timing = pref.getCreditPayTiming();
		
		// v擾
		int todayUse = 0;
		
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			todayUse = dao.selectDailyTotal(df.format(date));
		} else {
			// 
			todayUse = dao.selectDailyTotalAfterPay(df.format(date));
		}
		// {̎gpݒ
		views.setTextViewText(R.id.todayUse, decimalFormat.format(todayUse));

		// ̎gp擾
		SimpleDateFormat df3 = new SimpleDateFormat(dateFormat3);
		int monthTotal = 0;
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			monthTotal = dao.selectMonthlyTotal(df3.format(date));
		} else {
			// 
			monthTotal = dao.selectMonthlyTotalAfterPay(df3.format(date));
		}
		// ̎gpݒ
		views.setTextViewText(R.id.monthUse, decimalFormat.format(monthTotal));

		// ̖ڕW擾
		PlanMonthDao planDao = new PlanMonthDao(manager);
		Integer monthPlan = planDao.selectPlan(df3.format(date));
		String strMonthPlan = null;
		if (monthPlan == null) {
			strMonthPlan = "----";
		} else {
			strMonthPlan = decimalFormat.format(monthPlan);
		}
		// ̖ڕWݒ
		views.setTextViewText(R.id.monthPlan, strMonthPlan);

		// tݒ
		SimpleDateFormat df2 = new SimpleDateFormat(dateFormat2);
		views.setTextViewText(R.id.date, df2.format(date));

		/*
		 * Widgetɕ\Activityݒ肷
		 */
		Intent activityIntent = new Intent(context.getApplicationContext(), DailyDetailActivity.class);
		PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, activityIntent, PendingIntent.FLAG_UPDATE_CURRENT);
		views.setOnClickPendingIntent(R.id.layout, pendingIntent);

		/*
		 * Widget̃Abvf[gs
		 */
		ComponentName thisWidget = new ComponentName(context, MoneyWidget.class);
		AppWidgetManager widgetManager = AppWidgetManager.getInstance(context);
		widgetManager.updateAppWidget(thisWidget, views);
	}
}
