package net.atlabo.money.logic;

import net.atlabo.money.R;
import net.atlabo.money.util.Preference;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;
import android.app.Activity;
import android.util.Log;
import android.widget.Toast;

/**
 * {NXTwitter̃AJEgOAtuthĂāA
 * PreferenceɒlĂOŎgp邱
 * @author Atsushi Nakamoto
 *
 */
public class TwitterLogic {
	private Activity activity;

	private Twitter twitter;

	public TwitterLogic(Activity activity) {
		this.activity = activity;
		this.createTwitterInstance();
	}

	private void createTwitterInstance() {
		Preference pref = new Preference(activity);
		String accessToken = pref.getAccessToken();
		String accessTokenSecret = pref.getAccessTokenSecret();

		if (accessToken == null || accessTokenSecret == null) {
			return;
		}

		ConfigurationBuilder cbuilder = new ConfigurationBuilder();
		cbuilder.setOAuthConsumerKey(activity.getString(R.string.consumer_key));
		cbuilder.setOAuthConsumerSecret(activity.getString(R.string.consumer_secret));
		cbuilder.setOAuthAccessToken(accessToken);
		cbuilder.setOAuthAccessTokenSecret(accessTokenSecret);
		Configuration mConf = cbuilder.build();
		TwitterFactory twitterFactory = new TwitterFactory(mConf);
		twitter = twitterFactory.getInstance();
	}

	public boolean tweet(String s) {
		try {

			if (twitter == null) {
				return true;
			}

			if (s.length() > 140) {
				Toast.makeText(activity, "e140𒴉߂Ă܂B", Toast.LENGTH_LONG);
				return false;
			}

			twitter.updateStatus(s);
		} catch (TwitterException e) {
			Log.e("twitter", "cC[gɎs܂B", e);

			int statusCode = e.getStatusCode();
			if (statusCode == 401) {
				// F؃G[̏ꍇvt@X폜
				Preference pref = new Preference(activity);
				pref.setAccessToken(null);
				pref.setAccessTokenSecret(null);
				pref.commit();
			}

			Toast.makeText(activity, "cC[gɎs܂B[" + statusCode + "]", Toast.LENGTH_SHORT);
		}

		return true;
	}
}
