package net.atlabo.money.logic;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import net.atlabo.money.dao.BudgetDao;
import net.atlabo.money.dao.ConnectionManager;
import net.atlabo.money.dao.PlanMonthDao;
import net.atlabo.money.db.table.BudgetCreditcardExtTable;
import net.atlabo.money.db.table.BudgetTable;
import net.atlabo.money.db.table.PlanMonthTable;
import net.atlabo.money.util.Preference;
import net.atlabo.money.util.StringUtil;
import android.content.Context;
import android.util.Log;

public class MonthlyPlanLogic {
	private SimpleDateFormat df2 = new SimpleDateFormat("yyyyMM");

	/**
	 * ݌vƖڕWvZăXg𐶐
	 * Otp
	 * @param activity
	 * @param date
	 * @return
	 */
	public List<Map<String, Object>> buildRuikeiList(Context context, Date date) {
		List<Map<String, Object>> retList = new ArrayList<Map<String,Object>>();

		// NWbg^C~O擾
		Preference pref = new Preference(context);
		String timing = pref.getCreditPayTiming();
		
		ConnectionManager manager = ConnectionManager.getInstance(context);
		BudgetDao dao = new BudgetDao(manager);
		PlanMonthDao planDao = new PlanMonthDao(manager);

		List<Map<String, Object>> budgetList = null;
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			budgetList = dao.selectMonthlyByDay(df2.format(date));
		} else {
			// 
			budgetList = dao.selectMonthlyByDayAfterPay(df2.format(date));
		}
		Integer plan = planDao.selectPlan(df2.format(date));
		if (plan == null) {
			plan = 0;
		}

		Calendar cal = new GregorianCalendar();
		cal.setTime(date);
		cal.add(Calendar.MONTH, 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		// ̍ŏI擾
		int lastDayOfMonth = cal.get(Calendar.DAY_OF_MONTH);

		// ݌v
		int ruikei = 0;
		// l
		int amount = 0;
		
		int idate = 0;
		String status;

		Map<String, Object> map = null;
		for (int i=1; i<=lastDayOfMonth; i++) {
			// amount
			amount = 0;
			for (Map<String, Object> budgetMap : budgetList) {
				if (Preference.CREDIT_BUY.equals(timing)) {
					// x
					idate = Integer.parseInt((String) budgetMap.get(BudgetTable.COLUMN_TX_DATE));
				} else {
					// 
					status = (String) budgetMap.get(BudgetCreditcardExtTable.COLUMN_STATUS);
					if (status == null) {
						idate = Integer.parseInt((String) budgetMap.get(BudgetTable.COLUMN_TX_DATE));
					} else {
						idate = Integer.parseInt((String) budgetMap.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE));
					}
				}
				if (i == idate) {
					amount = budgetMap.get(BudgetTable.COLUMN_AMOUNT) == null
							? 0 : (Integer) budgetMap.get(BudgetTable.COLUMN_AMOUNT);
					ruikei += amount;

					break;
				}
			}

			map = createRecord(StringUtil.leftpadZero(Integer.toString(i), 2), amount, ruikei, plan);

			retList.add(map);
		}

		manager.close();

		return retList;
	}

	/**
	 * J_[p̃Xg𐶐
	 * @param activity
	 * @param date
	 * @return
	 */
	public List<List<Map<String, Object>>> buildCalendarList(Context context, Date date) {
		ConnectionManager manager = ConnectionManager.getInstance(context);
		
		// NWbg^C~O擾
		Preference pref = new Preference(context);
		String timing = pref.getCreditPayTiming();
		
		BudgetDao dao = new BudgetDao(manager);
		List<Map<String, Object>> budgetList = null;
		
		if (Preference.CREDIT_BUY.equals(timing)) {
			// x
			budgetList = dao.selectMonthlyByDay(df2.format(date));
		} else {
			// 
			budgetList = dao.selectMonthlyByDayAfterPay(df2.format(date));
		}

		Calendar cal = new GregorianCalendar();
		cal.setTime(date);
		cal.add(Calendar.MONTH, 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		// ̍ŏI擾
		int lastDayOfMonth = cal.get(Calendar.DAY_OF_MONTH);

		// 1ݒ
		cal.setTime(date);
		cal.set(Calendar.DAY_OF_MONTH, 1);

		List<List<Map<String, Object>>> weekList = new ArrayList<List<Map<String,Object>>>();
		List<Map<String, Object>> dayList = null;
		boolean breakFlg = false;
		while (true) {
			dayList = new ArrayList<Map<String,Object>>();
			for (int i=1; i<=7; i++) {
				if (i != cal.get(Calendar.DAY_OF_WEEK) || breakFlg) {
					// ݒ肷
					dayList.add(null);
				} else {
					// lݒ肷
					dayList.add(getMapFromList(budgetList, cal.get(Calendar.DAY_OF_MONTH), context));
					if (cal.get(Calendar.DAY_OF_MONTH) == lastDayOfMonth) {
						breakFlg = true;
					}

					// 
					cal.add(Calendar.DAY_OF_MONTH, 1);
				}
			}

			// TԃXgɒǉ
			weekList.add(dayList);

			if (breakFlg) {
				break;
			}
		}
		
		manager.close();

		return weekList;
	}

	private Map<String, Object> getMapFromList(List<Map<String, Object>> budgetList, int date, Context context) {
		Iterator<Map<String, Object>> it = budgetList.iterator();
		Map<String, Object> map = null;
		
		Preference pref = new Preference(context);
		String timing = pref.getCreditPayTiming();
		while (it.hasNext()) {
			map = it.next();
			Log.v("MonthlyPlanLogic", "getMapFromList map : " + map.toString());
			if (Preference.CREDIT_BUY.equals(timing)) {
				// x
				if (date == Integer.parseInt((
						(String) map.get(BudgetTable.COLUMN_TX_DATE)))) {
					return map;
				}
			} else {
				// 
				String status = (String) map.get(BudgetCreditcardExtTable.COLUMN_STATUS);
				
				if (status == null) {
					// Xe[^XNULL̏ꍇ͎xƓ
					if (date == Integer.parseInt((
							(String) map.get(BudgetTable.COLUMN_TX_DATE)))) {
						return map;
					}
				} else {
					// Xe[^XNULLł͂Ȃꍇ͈̏ꍇ
					String finishDate = (String) map.get(BudgetCreditcardExtTable.COLUMN_FINISH_DATE);
					if (finishDate == null) {
						continue;
					}
					if (date == Integer.parseInt(finishDate)) {
						map.put(BudgetTable.COLUMN_TX_DATE, finishDate);
						return map;
					}
				}
			}

		}

		Map<String, Object> tmpMap = new HashMap<String, Object>();
		tmpMap.put(BudgetTable.COLUMN_TX_DATE, Integer.toString(date));
		return tmpMap;
	}

	/**
	 * R[h쐬
	 * @param date dd
	 * @return
	 */
	private Map<String, Object> createRecord(String date, int amount, int ruikei, int plan) {
		Log.v("MonthlyPlanLogic", "createRecord : ["
				+ date + ", " + amount + ", " + ruikei + ", " + plan + "]");
		Map<String, Object> map = new HashMap<String, Object>();
		map.put(BudgetTable.COLUMN_TX_DATE, date);
		map.put(BudgetTable.COLUMN_AMOUNT, amount);
		map.put(BudgetTable.CONST_RUIKEI, ruikei);
		map.put(PlanMonthTable.COLUMN_PLAN_AMOUNT, plan);
		return map;
	}
}
