package net.atlabo.money.db.table;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import net.atlabo.money.exception.SystemException;

public class TableManager {
	private static final int MODE_CREATE = 1;
	private static final int MODE_UPDATE = 2;

	private Context context;

	/*
	 * e[u`
	 * e[u𑝂₷ꍇ͂ɒǉ邱
	 */
	@SuppressWarnings("rawtypes")
	private static final Class[] TABLE_CLASSES = {
		BudgetTable.class,
		PlanMonthTable.class,
		PlanTable.class,
		HistoryTable.class,
		BudgetCreditcardExtTable.class
	};

	/**
	 * RXgN^
	 * @param context
	 */
	public TableManager(Context context) {
		this.context = context;
	}

	/**
	 * AbstractTableNX̃CX^X𐶐ĕԋp
	 * @param c
	 * @return
	 */
	private AbstractTable getInstance(Class<AbstractTable> c) {
		try {
			AbstractTable table = c.newInstance();
			table.setContext(context);
			return table;
		} catch (Exception e) {
			throw new SystemException(
					"CX^X𐶐ł܂łB[NX : {0}]", e, c.getName());
		}
	}

	/**
	 * e[u쐬
	 * @param db
	 */
	public void createTable(SQLiteDatabase db) {
		execute(db, MODE_CREATE, 0, 0);
	}

	/**
	 * e[uXV
	 * TODO o[WقɂύX_̏ꍇKv
	 */
	public void updateTable(SQLiteDatabase db, int oldVersion, int newVersion) {
		execute(db, MODE_UPDATE, oldVersion, newVersion);
	}

	@SuppressWarnings("unchecked")
	private void execute(SQLiteDatabase db, int mode, int oldVersion, int newVersion) {
		AbstractTable table = null;
		String[] sqls = null;
		for (int i=0, size=TABLE_CLASSES.length; i<size; i++) {
			table = getInstance(TABLE_CLASSES[i]);

			/*
			 * [h
			 */
			switch (mode) {
			case MODE_CREATE:
				sqls = new String[]{table.getStatementOnCreate()};
				break;
			case MODE_UPDATE:
				sqls = table.getStatementOnUpdate(oldVersion, newVersion);
				break;
			default:
				break;
			}

			if (sqls == null) {
				// nullԋpꂽꍇ̓XLbv
				continue;
			}

			for (String sql : sqls) {
				if (sql == null) {
					continue;
				}
				db.execSQL(sql);
			}
		}
	}
}
