package net.atlabo.money.db.table;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Atsushi Nakamoto
 * 1Ƃ̖ڕWݒ肷gUNVe[u
 *
 */
public class PlanTable extends AbstractTable {
	public static final String COLUMN_TX_DATE = "TX_DATE";
	public static final String COLUMN_PLAN_AMOUNT = "PLAN_AMOUNT";

	@Override
	public String getStatementOnCreate() {
		return new SQLCreator().setTableName("PLAN")
			.addColumn(COLUMN_TX_DATE, 		ColumnType.TEXT)
			.addColumn(COLUMN_PLAN_AMOUNT,	ColumnType.INTEGER)
			.createSQL();
	}

	@Override
	public String[] getStatementOnUpdate(int oldVersion, int newVersion) {
		if (oldVersion == newVersion) {
			return null;
		}

		String sql = null;
		List<String> list = new ArrayList<String>();

		switch (oldVersion) {
		case 2:
			sql = new SQLCreator().setTableName("PLAN")
				.addColumn(COLUMN_TX_DATE, 		ColumnType.TEXT)
				.addColumn(COLUMN_PLAN_AMOUNT,	ColumnType.INTEGER)
				.createSQL();
			list.add(sql);
		default:
			break;
		}

		return (String[]) list.toArray(new String[list.size()]);
	}
}
