package net.atlabo.money.db.table;

import java.util.ArrayList;
import java.util.List;

import net.atlabo.money.receiver.ConvertReceiver;
import android.content.Intent;


/**
 *
 * @author Atsushi Nakamoto
 * 1Ƃ̖ڕWݒ肷gUNVe[u
 *
 */
public class PlanMonthTable extends AbstractTable {
	public static final String COLUMN_TX_MONTH = "TX_MONTH";
	public static final String COLUMN_PLAN_AMOUNT = "PLAN_AMOUNT";

	@Override
	public String getStatementOnCreate() {
		return new SQLCreator().setTableName("PLAN_MONTH")
			.addColumn(COLUMN_TX_MONTH,		ColumnType.TEXT)
			.addColumn(COLUMN_PLAN_AMOUNT,	ColumnType.INTEGER)
			.createSQL();
	}

	@Override
	public String[] getStatementOnUpdate(int oldVersion, int newVersion) {
		if (oldVersion == newVersion) {
			return null;
		}

		String sql = null;
		List<String> list = new ArrayList<String>();

		// PLAN_MONTHe[u쐬
		if (oldVersion <= 4) {
			sql = new SQLCreator().setTableName("PLAN_MONTH")
					.addColumn(COLUMN_TX_MONTH,		ColumnType.TEXT)
					.addColumn(COLUMN_PLAN_AMOUNT,	ColumnType.INTEGER)
					.createSQL();
			list.add(sql);
		}

		// PLANe[uRo[g
		if (oldVersion <= 6) {
			Intent intent = new Intent("ACTION_CONVERT");
			context.sendBroadcast(intent);
		}


		return (String[]) list.toArray(new String[list.size()]);
	}
}
