package net.atlabo.money.db.table;


/**
 * BUDGET_CREDITCARD_EXTe[u
 * BUDGETe[ũNJgp̃e[u
 * ETX_ID	gUNVӂɎʂID		TEXT
 * 			BUDGETe[uƓlݒ肷
 * ESTATUS	xXe[^X					TEXT
 * 			0F@1Fx
 * EFINISH_DATE	x						TEXT
 * ECREDITCARD_ID	NWbgJ[hID			TEXT
 * 
 * 
 * @author Atsushi Nakamoto
 *
 */
public class BudgetCreditcardExtTable extends AbstractTable {
	
	public static final String COLUMN_TX_ID = "TX_ID";
	public static final String COLUMN_STATUS = "STATUS";
	public static final String COLUMN_FINISH_DATE = "FINISH_DATE";
	public static final String COLUMN_CREDITCARD_ID = "CREDITCARD_ID";
	
	public static final String CHECKED = "CHECKED";

	@Override
	public String getStatementOnCreate() {
		return new SQLCreator().setTableName("BUDGET_CREDITCARD_EXT")
				.addColumn(COLUMN_TX_ID, 		ColumnType.TEXT)
				.addColumn(COLUMN_STATUS,		ColumnType.TEXT)
				.addColumn(COLUMN_FINISH_DATE,	ColumnType.TEXT)
				.addColumn(COLUMN_CREDITCARD_ID,	ColumnType.TEXT)
				.createSQL();
	}

	@Override
	public String[] getStatementOnUpdate(int oldVersion, int newVersion) {
		if (oldVersion == newVersion) {
			return null;
		}
		
		if (oldVersion < 14) {
			return new String[]{new SQLCreator().setTableName("BUDGET_CREDITCARD_EXT")
					.addColumn(COLUMN_TX_ID, 		ColumnType.TEXT)
					.addColumn(COLUMN_STATUS,		ColumnType.TEXT)
					.addColumn(COLUMN_FINISH_DATE,	ColumnType.TEXT)
					.addColumn(COLUMN_CREDITCARD_ID,	ColumnType.TEXT)
					.createSQL()};
		}
		
		return null;
	}

}
