package net.atlabo.money.dao;

import java.util.Map;

import net.atlabo.money.db.table.PlanMonthTable;
import android.database.sqlite.SQLiteCursor;

/**
 * ̖ڕWv悷e[uւ̃ANZXNX
 * @author Atsushi Nakamoto
 *
 */
public class PlanMonthDao extends BaseDao {

	/**
	 * RXgN^
	 * @param context
	 */
	public PlanMonthDao(ConnectionManager manager) {
		super(manager);
	}

	/**
	 * vo^
	 * @param map
	 */
	public void insertPlan(Map<String, Object> map) {
		String sql = "insert into PLAN_MONTH ( "
				+ PlanMonthTable.COLUMN_TX_MONTH + ", "
				+ PlanMonthTable.COLUMN_PLAN_AMOUNT + " "
			+ ") values ( "
				+ "?, "
				+ "? "
			+ ") ";

		manager.insert(sql, new String[]{
				(String) map.get(PlanMonthTable.COLUMN_TX_MONTH),
				Integer.toString((Integer) map.get(PlanMonthTable.COLUMN_PLAN_AMOUNT))
		});
	}

	/**
	 * ڕW擾
	 * ݒ肳ĂȂꍇNullԋp
	 * @param date yyyyMMtH[}bg
	 * @return
	 */
	public Integer selectPlan(String date) {
		Integer amount = null;
		String sql = "select PLAN_AMOUNT from PLAN_MONTH where TX_MONTH = ? ";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{date});

		if (c.moveToNext()) {
			amount = c.getInt(0);
		}

		c.close();

		return amount;
	}

	/**
	 * vXV
	 * @param map
	 */
	public void updatePlan(Map<String, Object> map) {
		String sql = "update PLAN_MONTH set PLAN_AMOUNT = ? where TX_MONTH = ? ";
		
		manager.update(sql, new String[]{
				Integer.toString((Integer) map.get(PlanMonthTable.COLUMN_PLAN_AMOUNT)),
				(String) map.get(PlanMonthTable.COLUMN_TX_MONTH)
		});

	}
}
