package net.atlabo.money.dao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.atlabo.money.db.table.PlanMonthTable;
import net.atlabo.money.db.table.PlanTable;
import net.atlabo.money.exception.SystemException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteStatement;

/**
 * ̖ڕWv悷e[uւ̃ANZXNX
 * @author Atsushi Nakamoto
 * @deprecated
 */
public class PlanDao extends BaseDao {

	/**
	 * RXgN^
	 * @param context
	 */
	public PlanDao(ConnectionManager manager) {
		super(manager);
	}

	/**
	 * vo^
	 * @param map
	 */
	public void insertPlan(Map<String, Object> map) {
		String sql = "insert into PLAN ( "
				+ PlanTable.COLUMN_TX_DATE + ", "
				+ PlanTable.COLUMN_PLAN_AMOUNT + " "
			+ ") values ( "
				+ "?, "
				+ "? "
			+ ") ";

		manager.select(sql, new String[]{
				(String) map.get(PlanTable.COLUMN_TX_DATE),
				Integer.toString((Integer) map.get(PlanTable.COLUMN_PLAN_AMOUNT))
		});
	}

	/**
	 * ڕW擾
	 * ݒ肳ĂȂꍇNullԋp
	 * @param date yyyyMMddtH[}bg
	 * @return
	 */
	public Integer selectPlan(String date) {
		Integer amount = null;
		String sql = "select PLAN_AMOUNT from PLAN where TX_DATE = ? ";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{date});

		if (c.moveToNext()) {
			amount = c.getInt(0);
		}

		c.close();

		return amount;
	}

	/**
	 * ̖ڕW擾
	 * ݒ肳ĂȂꍇNullԋp
	 * @param date yyyyMM tH[}bg
	 * @return
	 */
	public Integer selectMonthlyPlan(String date) {
		Integer amount = null;
		String start = date + "01";
		String end = date + "31";

		String sql = "select SUM(PLAN_AMOUNT) TOTAL_PLAN_AMOUNT from PLAN where TX_DATE between ? and ? ";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end});

		if (c.moveToNext()) {
			return c.getInt(0);
		}

		c.close();

		return amount;
	}

	/**
	 * Ƃ1̃R[h擾
	 * @param date
	 * @return
	 */
	public List<Map<String, Object>> selectMonthlyPlanByDay(String date) {
		String sql = "select substr(TX_DATE, 7, 2) TX_DATE, PLAN_AMOUNT PLAN_AMOUNT "
			+ "from PLAN "
			+ "where TX_DATE between ? and ? "
			+ "order by TX_DATE asc ";

		String start = date + "01";
		String end = date + "31";

		SQLiteCursor c = (SQLiteCursor) manager.select(sql, new String[]{start, end});

		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		Map<String, Object> map = null;

		while (c.moveToNext()) {
			map = new HashMap<String, Object>();
			map.put(PlanTable.COLUMN_TX_DATE, c.getString(0));
			map.put(PlanTable.COLUMN_PLAN_AMOUNT, c.getInt(1));
			list.add(map);
		}

		c.close();

		return list;
	}

	/**
	 * vXV
	 * @param map
	 */
	public void updatePlan(Map<String, Object> map) {
		String sql = "update PLAN set PLAN_AMOUNT = ? where TX_DATE = ? ";

		manager.update(sql, new String[]{
				Integer.toString((Integer) map.get(PlanMonthTable.COLUMN_PLAN_AMOUNT)),
				(String) map.get(PlanTable.COLUMN_TX_DATE)
		});

	}


	/**
	 * 1̗\ꊇo^
	 * U폜Ăo^
	 * @param map
	 * @param date yyyyMM
	 */
	public void registPlanMonthly(Map<String, Object> map, String date) {
		SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
		SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
		String delSql = "delete from PLAN where TX_DATE like ? ";
		String regsql = "insert into PLAN ( "
				+ PlanTable.COLUMN_TX_DATE + ", "
				+ PlanTable.COLUMN_PLAN_AMOUNT + " "
			+ ") values ( "
				+ "?, "
				+ "? "
			+ ") ";

		// ͈͂擾
		Calendar cal = new GregorianCalendar();
		try {
			cal.setTime(df.parse(date));
		} catch (ParseException e) {
			// ܂肦Ȃ
			throw new SystemException("G[܂B", e);
		}

		cal.set(Calendar.DAY_OF_MONTH, 1);

		// Jn
		int iStart = Integer.parseInt(df2.format(cal.getTime()));

		cal.add(Calendar.MONTH, 1);
		cal.add(Calendar.DAY_OF_MONTH, -1);

		// I
		int iEnd = Integer.parseInt(df2.format(cal.getTime()));

		SQLiteStatement stmt = null;

		// 폜
		manager.delete(delSql, new String[]{date + "%"});

		// o^
		stmt = manager.prepareStatement(regsql);

		for (int i=iStart; i<=iEnd; i++) {
			stmt.bindString(1, Integer.toString(i));
			stmt.bindLong(2, (Integer) map.get(PlanMonthTable.COLUMN_PLAN_AMOUNT));
			stmt.executeInsert();
		}

		if (stmt != null) {
			stmt.close();
		}
	}

	/**
	 * PLANe[uPLAN_AMOUNTe[uւ̃Ro[g
	 */
	public void convertPlan() {
		String selSql = "select "
							+ "substr(TX_DATE, 1, 6) TX_DATE, "
							+ "sum(PLAN_AMOUNT) PLAN_AMOUNT "
						+ "from PLAN "
						+ "group by substr(TX_DATE, 1, 6) ";

		String insSql = "insert into PLAN_MONTH (TX_MONTH, PLAN_AMOUNT) values (?, ?) ";

		SQLiteCursor c = null;

		c = (SQLiteCursor) manager.select(selSql, null);

		while (c.moveToNext()) {
			String month = c.getString(0);
			Integer amount = c.getInt(1);
			if (amount == null) {
				amount = 0;
			}

			manager.insert(insSql, new Object[]{month, amount});
		}

		c.close();
	}

}
